/// <reference path="./internal_*.d.ts" />
declare namespace dev.architectury.event {
    class EventResult {
        static interrupt(value: boolean): dev.architectury.event.EventResult;
        isPresent(): boolean;
        isTrue(): boolean;
        static interruptDefault(): dev.architectury.event.EventResult;
        asMinecraft(): Internal.InteractionResult;
        isFalse(): boolean;
        interruptsFurtherEvaluation(): boolean;
        static interruptTrue(): dev.architectury.event.EventResult;
        value(): boolean;
        static pass(): dev.architectury.event.EventResult;
        isEmpty(): boolean;
        static interruptFalse(): dev.architectury.event.EventResult;
        get present(): boolean
        get "true"(): boolean
        get "false"(): boolean
        get empty(): boolean
    }
    type EventResult_ = EventResult;
}
declare namespace com.illusivesoulworks.polymorph.mixin.core {
    interface AccessorSmithingTrimRecipe {
        abstract getTemplate(): Internal.Ingredient;
        abstract getBase(): Internal.Ingredient;
        abstract getAddition(): Internal.Ingredient;
        get template(): Internal.Ingredient
        get base(): Internal.Ingredient
        get addition(): Internal.Ingredient
    }
    type AccessorSmithingTrimRecipe_ = AccessorSmithingTrimRecipe;
}
declare namespace Internal {
    class EnergyCellItem extends Internal.EnergyBlockItem<Internal.EnergyConfig, Internal.EnergyCellBlock> implements Internal.IEnderExtender {
        constructor(block: Internal.EnergyCellBlock_, properties: Internal.Item$Properties_, group: Internal.ResourceKey_<Internal.CreativeModeTab>)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        oneTimeInfo(player: Internal.Player_, stack: Internal.ItemStack_, component: net.minecraft.network.chat.Component_): void;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getVariant(): Internal.IVariant<any>;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getExtendedCapacity(stack: Internal.ItemStack_): number;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getExtendedEnergy(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get variant(): Internal.IVariant<any>
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type EnergyCellItem_ = EnergyCellItem;
    class ModifierNBT {
        constructor(modifiers: Internal.List_<Internal.ModifierEntry>)
        static builder(): Internal.ModifierNBT$Builder;
        static readFromNBT(inbt: Internal.Tag_): Internal.ModifierNBT;
        withModifier(modifier: Internal.ModifierId_, level: number): this;
        serializeToNBT(): Internal.ListTag;
        getEntry(modifier: Internal.ModifierId_): Internal.ModifierEntry;
        getModifiers(): Internal.List<Internal.ModifierEntry>;
        isEmpty(): boolean;
        getLevel(modifier: Internal.ModifierId_): number;
        withoutModifier(modifier: Internal.ModifierId_, level: number): this;
        get modifiers(): Internal.List<Internal.ModifierEntry>
        get empty(): boolean
        static readonly TAG_MODIFIER: "name";
        static readonly TAG_LEVEL: "level";
        static readonly EMPTY: Internal.ModifierNBT;
    }
    type ModifierNBT_ = ModifierNBT;
    abstract class ItemMediaHolder extends Internal.Item implements Internal.MediaHolderItem {
        constructor(pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getConsumptionPriority(stack: Internal.ItemStack_): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        abstract canRecharge(arg0: Internal.ItemStack_): boolean;
        insertMedia(stack: Internal.ItemStack_, amount: number, simulate: boolean): number;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        getMedia(stack: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        static withMedia(stack: Internal.ItemStack_, media: number, maxMedia: number): Internal.ItemStack;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getMediaFullness(stack: Internal.ItemStack_): number;
        abstract canProvideMedia(arg0: Internal.ItemStack_): boolean;
        emi(amount: number): Internal.EmiStack;
        setMedia(stack: Internal.ItemStack_, media: number): void;
        withdrawMedia(stack: Internal.ItemStack_, cost: number, simulate: boolean): number;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        getMaxMedia(stack: Internal.ItemStack_): number;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly TAG_MEDIA: "hexcasting:media";
        static readonly TAG_MAX_MEDIA: "hexcasting:start_media";
        static readonly HEX_COLOR: Internal.TextColor;
    }
    type ItemMediaHolder_ = ItemMediaHolder;
    interface BlockInterfaceHelper {
        getExplosionResistance(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, explosion: Internal.Explosion_): number;
        canEntityDestroy(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, entity: Internal.Entity_): boolean;
    }
    type BlockInterfaceHelper_ = BlockInterfaceHelper;
    class DropperBlockEntity extends Internal.DispenserBlockEntity {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        stopOpen($$0: Internal.Player_): void;
        stopListenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        static tryClear($$0: any): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        getSlots(): number;
        setChanged(): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        asComponentProvider(): Internal.ComponentProvider;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        fabric_onTransfer(slot: number, transaction: Internal.TransactionContext_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        emitCallbackReplaced(): void;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isEmpty(): boolean;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        shouldCloseCurrentScreen(): boolean;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        listenForContentChangesOnce(stackList: Internal.LithiumStackList_, inventoryChangeListener: Internal.InventoryChangeListener_): void;
        getHeight(): number;
        countNonEmpty(): number;
        listenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        asContainer(): net.minecraft.world.Container;
        getAllItems(): Internal.List<Internal.ItemStack>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        generateLootLithium(): void;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        get slots(): number
        get width(): number
        get maxStackSize(): number
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get height(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
    }
    type DropperBlockEntity_ = DropperBlockEntity;
    class ItemModPickaxe extends Internal.PickaxeItem implements Internal.DragonSteelOverrides<Internal.ItemModPickaxe> {
        constructor(toolmaterial: Internal.Tier_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isDragonSteelLightning(tier: Internal.Tier_): boolean;
        isDragonSteelFire(tier: Internal.Tier_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isDragonSteel(tier: Internal.Tier_): boolean;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        appendHoverText(tier: Internal.Tier_, stack: Internal.ItemStack_, worldIn: Internal.Level_, tooltip: Internal.List_<net.minecraft.network.chat.Component>, flagIn: Internal.TooltipFlag_): void;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        hurtEnemy(item: Internal.ItemModPickaxe_, stack: Internal.ItemStack_, target: Internal.LivingEntity_, attacker: Internal.LivingEntity_): void;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        isDragonSteelIce(tier: Internal.Tier_): boolean;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        getAttackDamage(item: Internal.ItemModPickaxe_): number;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        /**
         * @deprecated
        */
        bakeDragonsteel(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemModPickaxe_ = ItemModPickaxe;
    class SuperGlueItem extends Internal.Item {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        static glueItemAlwaysPlacesWhenUsed(player: Internal.Player_, world: Internal.Level_, hand: Internal.InteractionHand_, hitResult: Internal.BlockHitResult_): Internal.InteractionResult;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        static spawnParticles(world: Internal.Level_, pos: BlockPos_, direction: Internal.Direction_, fullBlock: boolean): void;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SuperGlueItem_ = SuperGlueItem;
    class DropTarget implements Internal.DropTargetListener, Internal.Serializable {
        constructor()
        constructor(arg0: Internal.Component_, arg1: number, arg2: Internal.DropTargetListener_, arg3: boolean, arg4: Internal.FlavorMap_)
        constructor(arg0: Internal.Component_, arg1: number, arg2: Internal.DropTargetListener_)
        constructor(arg0: Internal.Component_, arg1: Internal.DropTargetListener_)
        constructor(arg0: Internal.Component_, arg1: number, arg2: Internal.DropTargetListener_, arg3: boolean)
        setComponent(arg0: Internal.Component_): void;
        setDefaultActions(arg0: number): void;
        removeDropTargetListener(arg0: Internal.DropTargetListener_): void;
        dragOver(arg0: Internal.DropTargetDragEvent_): void;
        isActive(): boolean;
        getDropTargetContext(): Internal.DropTargetContext;
        dragExit(arg0: Internal.DropTargetEvent_): void;
        setFlavorMap(arg0: Internal.FlavorMap_): void;
        removeNotify(): void;
        drop(arg0: Internal.DropTargetDropEvent_): void;
        dragEnter(arg0: Internal.DropTargetDragEvent_): void;
        getComponent(): Internal.Component;
        setActive(arg0: boolean): void;
        getFlavorMap(): Internal.FlavorMap;
        dropActionChanged(arg0: Internal.DropTargetDragEvent_): void;
        addNotify(): void;
        addDropTargetListener(arg0: Internal.DropTargetListener_): void;
        getDefaultActions(): number;
        set component(arg0: Internal.Component_)
        set defaultActions(arg0: number)
        get active(): boolean
        get dropTargetContext(): Internal.DropTargetContext
        set flavorMap(arg0: Internal.FlavorMap_)
        get component(): Internal.Component
        set active(arg0: boolean)
        get flavorMap(): Internal.FlavorMap
        get defaultActions(): number
    }
    type DropTarget_ = DropTarget;
    /**
     * Invoked when a player crafts an item.
    */
    class ItemCraftedEventJS extends Internal.PlayerEventJS {
        constructor(player: Internal.Player_, crafted: Internal.ItemStack_, container: net.minecraft.world.Container_)
        /**
         * The inventory that the item was crafted in.
        */
        getInventory(): Internal.InventoryKJS;
        /**
         * The player that crafted the item.
        */
        getEntity(): Internal.LivingEntity;
        /**
         * The item that was crafted.
        */
        getItem(): Internal.ItemStack;
        /**
         * The inventory that the item was crafted in.
        */
        get inventory(): Internal.InventoryKJS
        /**
         * The player that crafted the item.
        */
        get entity(): Internal.LivingEntity
        /**
         * The item that was crafted.
        */
        get item(): Internal.ItemStack
    }
    type ItemCraftedEventJS_ = ItemCraftedEventJS;
    class AppEngInternalInventory extends Internal.BaseInternalInventory {
        constructor(inventory: Internal.InternalInventoryHost_, size: number, maxStack: number)
        constructor(size: number)
        constructor(inventory: Internal.InternalInventoryHost_, size: number)
        constructor(host: Internal.InternalInventoryHost_, size: number, maxStack: number, filter: Internal.IAEItemFilter_)
        setFilter(filter: Internal.IAEItemFilter_): void;
        simulateRemove(amount: number, filter: Internal.ItemStack_, destination: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        addItems(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        toContainer(): net.minecraft.world.Container;
        getSubInventory(fromSlotInclusive: number, toSlotExclusive: number): Internal.InternalInventory;
        isEmpty(): boolean;
        getHost(): Internal.InternalInventoryHost;
        writeToNBT(data: Internal.CompoundTag_, name: string): void;
        readFromNBT(data: Internal.CompoundTag_, name: string): void;
        removeItems(amount: number, filter: Internal.ItemStack_, destination: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        removeSimilarItems(amount: number, filter: Internal.ItemStack_, fuzzyMode: Internal.FuzzyMode_, destination: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        setEnableClientEvents(enableClientEvents: boolean): void;
        static wrapExternal(be: Internal.BlockEntity_, side: Internal.Direction_): Internal.ItemTransfer;
        static empty(): Internal.InternalInventory;
        getSlotInv(slotIndex: number): Internal.InternalInventory;
        setMaxStackSize(slot: number, size: number): void;
        mayAllowInsertion(): boolean;
        addItems(stack: Internal.ItemStack_): Internal.ItemStack;
        iterator(): Internal.Iterator<Internal.ItemStack>;
        simulateSimilarRemove(amount: number, filter: Internal.ItemStack_, fuzzyMode: Internal.FuzzyMode_, destination: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        spliterator(): Internal.Spliterator<Internal.ItemStack>;
        simulateAdd(stack: Internal.ItemStack_): Internal.ItemStack;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        forEach(arg0: Internal.Consumer_<Internal.ItemStack>): void;
        clear(): void;
        getRedstoneSignal(): number;
        static wrapExternal(level: Internal.Level_, pos: BlockPos_, side: Internal.Direction_): Internal.ItemTransfer;
        set filter(filter: Internal.IAEItemFilter_)
        get empty(): boolean
        get host(): Internal.InternalInventoryHost
        set enableClientEvents(enableClientEvents: boolean)
        get redstoneSignal(): number
    }
    type AppEngInternalInventory_ = AppEngInternalInventory;
    class CreativeModeTabModifier implements Internal.CreativeModeTab$Output {
        constructor(flags: Internal.Supplier_<Internal.FeatureFlagSet>, hasPermissions: Internal.BooleanSupplier_, acceptFunc: Internal.BiConsumer_<Internal.ItemStack, Internal.CreativeModeTab$TabVisibility>)
        acceptAll($$0: Internal.Collection_<Internal.ItemStack>, $$1: Internal.CreativeModeTab$TabVisibility_): void;
        accept($$0: Internal.ItemStack_): void;
        getFlags(): Internal.FeatureFlagSet;
        hasPermissions(): boolean;
        accept(stack: Internal.ItemStack_, visibility: Internal.CreativeModeTab$TabVisibility_): void;
        accept($$0: Internal.ItemLike_, $$1: Internal.CreativeModeTab$TabVisibility_): void;
        accept(item: Internal.Supplier_<Internal.ItemLike>): void;
        acceptAll($$0: Internal.Collection_<Internal.ItemStack>): void;
        accept(item: Internal.Supplier_<Internal.ItemLike>, visibility: Internal.CreativeModeTab$TabVisibility_): void;
        accept($$0: Internal.ItemLike_): void;
        get flags(): Internal.FeatureFlagSet
    }
    type CreativeModeTabModifier_ = CreativeModeTabModifier;
    class ItemHydraHeart extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemHydraHeart_ = ItemHydraHeart;
    class BlockDreadWoodLog extends Internal.RotatedPillarBlock implements Internal.IDreadBlock, Internal.IDragonProof {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type BlockDreadWoodLog_ = BlockDreadWoodLog;
    interface TypeWrapperFactory$Simple <T> extends Internal.TypeWrapperFactory<T> {
        wrap(cx: Internal.Context_, o: any): T;
        abstract wrapSimple(arg0: any): T;
        (arg0: any): T;
    }
    type TypeWrapperFactory$Simple_<T> = TypeWrapperFactory$Simple<T>;
    class Vex extends Internal.Monster implements Internal.TraceableEntity {
        constructor($$0: Internal.EntityType_<Internal.Vex>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        setBoundOrigin($$0: BlockPos_): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        getBoundOrigin(): BlockPos;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        getOwner(): Internal.Entity;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        method_5776(): boolean;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        setLimitedLife($$0: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        setIsCharging($$0: boolean): void;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        getOwner(): Internal.Mob;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        isCharging(): boolean;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setOwner($$0: Internal.Mob_): void;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        set boundOrigin($$0: BlockPos_)
        get living(): boolean
        get boundOrigin(): BlockPos
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get owner(): Internal.Entity
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        set limitedLife($$0: number)
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        set isCharging($$0: boolean)
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get owner(): Internal.Mob
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get charging(): boolean
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set owner($$0: Internal.Mob_)
        set headArmorItem(item: Internal.ItemStack_)
        static readonly TICKS_PER_FLAP: 4;
        static readonly FLAP_DEGREES_PER_TICK: 45.836624;
    }
    type Vex_ = Vex;
    class DualNoiseProvider extends Internal.NoiseProvider {
        constructor($$0: Internal.InclusiveRange_<number>, $$1: Internal.NormalNoise$NoiseParameters_, $$2: number, $$3: number, $$4: Internal.NormalNoise$NoiseParameters_, $$5: number, $$6: Internal.List_<Internal.BlockState>)
        static readonly CODEC: Internal.Codec<Internal.DualNoiseProvider>;
    }
    type DualNoiseProvider_ = DualNoiseProvider;
    class SpeedControllerBlock extends Internal.HorizontalAxisKineticBlock implements Internal.IBE<Internal.SpeedControllerBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.SpeedControllerBlockEntity>): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getBlockEntityClass(): typeof Internal.SpeedControllerBlockEntity;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.SpeedControllerBlockEntity;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.SpeedControllerBlockEntity>;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        showCapacityWithAnnotation(): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.SpeedControllerBlockEntity>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.SpeedControllerBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityClass(): typeof Internal.SpeedControllerBlockEntity
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.SpeedControllerBlockEntity>
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
    }
    type SpeedControllerBlock_ = SpeedControllerBlock;
    interface Watchable {
        abstract register(arg0: Internal.WatchService_, ...arg1: Internal.WatchEvent$Kind_<any>[]): Internal.WatchKey;
        abstract register(arg0: Internal.WatchService_, arg1: Internal.WatchEvent$Kind_<any>[], ...arg2: any_[]): Internal.WatchKey;
    }
    type Watchable_ = Watchable;
    class Cat extends Internal.TamableAnimal implements Internal.VariantHolder<Internal.CatVariant> {
        constructor($$0: Internal.EntityType_<Internal.Cat>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        getLieDownAmount($$0: number): number;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getOwner(): Internal.LivingEntity;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        isRelaxStateOne(): boolean;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setCollarColor($$0: Internal.DyeColor_): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        setVariant($$0: Internal.CatVariant_): void;
        getVariant(): any;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        getBreedOffspring($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): this;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getCollarColor(): Internal.DyeColor;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        method_5958(): void;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        getVariant(): Internal.CatVariant;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setRelaxStateOne($$0: boolean): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        hiss(): void;
        getRelaxStateOneAmount($$0: number): number;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        isLying(): boolean;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        getResourceLocation(): ResourceLocation;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        getLieDownAmountTail($$0: number): number;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        setVariant(arg0: any): void;
        runCommand(command: string): number;
        setLying($$0: boolean): void;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get owner(): Internal.LivingEntity
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get relaxStateOne(): boolean
        get displayName(): net.minecraft.network.chat.Component
        set collarColor($$0: Internal.DyeColor_)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        set variant($$0: Internal.CatVariant_)
        get variant(): any
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get collarColor(): Internal.DyeColor
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get variant(): Internal.CatVariant
        set relaxStateOne($$0: boolean)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get lying(): boolean
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        get resourceLocation(): ResourceLocation
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        set variant(arg0: any)
        set lying($$0: boolean)
        static readonly TEMPT_SPEED_MOD: 0.6;
        static readonly SPRINT_SPEED_MOD: 1.33;
        static readonly WALK_SPEED_MOD: 0.8;
    }
    type Cat_ = Cat;
    class ShapelessKubeJSRecipe$SerializerKJS implements Internal.RecipeSerializer<Internal.ShapelessKubeJSRecipe> {
        constructor()
        fromNetwork(id: ResourceLocation_, buf: Internal.FriendlyByteBuf_): Internal.ShapelessKubeJSRecipe;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): Internal.ShapelessKubeJSRecipe;
        toNetwork(buf: Internal.FriendlyByteBuf_, r: Internal.ShapelessKubeJSRecipe_): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
    }
    type ShapelessKubeJSRecipe$SerializerKJS_ = ShapelessKubeJSRecipe$SerializerKJS;
    interface BlockBuilderProvider {
        getBlockBuilder(): Internal.BlockBuilder;
        get blockBuilder(): Internal.BlockBuilder
    }
    type BlockBuilderProvider_ = BlockBuilderProvider;
    interface TooltipComponent {
    }
    type TooltipComponent_ = TooltipComponent;
    class BeltInventory {
        constructor(be: Internal.BeltBlockEntity_)
        write(): Internal.CompoundTag;
        applyToEachWithin(position: number, maxDistanceToPosition: number, processFunction: Internal.Function_<Internal.TransportedItemStack, Internal.TransportedItemStackHandlerBehaviour$TransportedResult>): void;
        read(nbt: Internal.CompoundTag_): void;
        addItem(newStack: Internal.TransportedItemStack_): void;
        getTransportedItems(): Internal.List<Internal.TransportedItemStack>;
        getStackAtOffset(offset: number): Internal.TransportedItemStack;
        canInsertAtFromSide(segment: number, side: Internal.Direction_): boolean;
        canInsertAt(segment: number): boolean;
        getLazyClientItem(): Internal.TransportedItemStack;
        tick(): void;
        ejectAll(): void;
        eject(stack: Internal.TransportedItemStack_): void;
        get transportedItems(): Internal.List<Internal.TransportedItemStack>
        get lazyClientItem(): Internal.TransportedItemStack
        readonly toInsertSnapshotParticipant: Internal.BeltInventory$ToInsertSnapshotParticipant;
        readonly itemsSnapshotParticipant: Internal.BeltInventory$ItemsSnapshotParticipant;
    }
    type BeltInventory_ = BeltInventory;
    class FullChunkStatus extends Internal.Enum<Internal.FullChunkStatus> {
        static valueOf($$0: string): Internal.FullChunkStatus;
        isOrAfter($$0: Internal.FullChunkStatus_): boolean;
        static values(): Internal.FullChunkStatus[];
        static readonly BLOCK_TICKING: Internal.FullChunkStatus;
        static readonly INACCESSIBLE: Internal.FullChunkStatus;
        static readonly ENTITY_TICKING: Internal.FullChunkStatus;
        static readonly FULL: Internal.FullChunkStatus;
    }
    type FullChunkStatus_ = "inaccessible" | "entity_ticking" | "full" | FullChunkStatus | "block_ticking";
    class EnderpearlItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type EnderpearlItem_ = EnderpearlItem;
    class ExplosionDamageCalculator {
        constructor()
        shouldBlockExplode($$0: Internal.Explosion_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.BlockState_, $$4: number): boolean;
        handler$zbm000$porting_lib_base$port_lib$explosionBlock(explosion: Internal.Explosion_, reader: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, fluid: Internal.FluidState_, cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$hpb000$sophisticatedbackpacks$sophisticatedBackpacks$getBlockExplosionResistance(explosion: Internal.Explosion_, reader: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, fluid: Internal.FluidState_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getBlockExplosionResistance($$0: Internal.Explosion_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.BlockState_, $$4: Internal.FluidState_): Internal.Optional<number>;
    }
    type ExplosionDamageCalculator_ = ExplosionDamageCalculator;
    class ItemThroughputDisplaySource extends Internal.AccumulatedItemCountDisplaySource {
        constructor()
    }
    type ItemThroughputDisplaySource_ = ItemThroughputDisplaySource;
    class WeighedSoundEvents implements Internal.Weighted<Internal.Sound> {
        constructor($$0: ResourceLocation_, $$1: string)
        getSound(arg0: Internal.RandomSource_): any;
        addSound($$0: Internal.Weighted_<Internal.Sound>): void;
        getSound($$0: Internal.RandomSource_): Internal.Sound;
        getWeight(): number;
        preloadIfRequired($$0: Internal.SoundEngine_): void;
        getSubtitle(): net.minecraft.network.chat.Component;
        get weight(): number
        get subtitle(): net.minecraft.network.chat.Component
    }
    type WeighedSoundEvents_ = WeighedSoundEvents;
    class ModularAccumulatorBlock extends Internal.Block implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.ModularAccumulatorBlockEntity>, Internal.CustomSoundTypeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static creative(props: Internal.BlockBehaviour$Properties_): Internal.ModularAccumulatorBlock;
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        static isAccumulator(state: Internal.BlockState_): boolean;
        getBlockEntityClass(): typeof Internal.ModularAccumulatorBlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.ModularAccumulatorBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.ModularAccumulatorBlockEntity;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.ModularAccumulatorBlockEntity>): void;
        static regular(props: Internal.BlockBehaviour$Properties_): Internal.ModularAccumulatorBlock;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.ModularAccumulatorBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.ModularAccumulatorBlockEntity>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        getSoundType(state: Internal.BlockState_, world: Internal.LevelReader_, pos: BlockPos_, entity: Internal.Entity_): SoundType;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockEntityClass(): typeof Internal.ModularAccumulatorBlockEntity
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.ModularAccumulatorBlockEntity>
        static readonly TOP: Internal.BooleanProperty;
        static readonly BOTTOM: Internal.BooleanProperty;
        static readonly SILENCED_METAL: Internal.LazySoundType;
    }
    type ModularAccumulatorBlock_ = ModularAccumulatorBlock;
    class BehaviourType <T extends Internal.BlockEntityBehaviour> {
        constructor()
        constructor(name: string)
        getName(): string;
        get name(): string
    }
    type BehaviourType_<T extends Internal.BlockEntityBehaviour> = BehaviourType<T>;
    interface AnnotatedType extends Internal.AnnotatedElement {
        getAnnotationsByType<T extends Internal.Annotation>(arg0: T): T[];
        getDeclaredAnnotation<T extends Internal.Annotation>(arg0: T): T;
        getAnnotatedOwnerType(): this;
        getDeclaredAnnotationsByType<T extends Internal.Annotation>(arg0: T): T[];
        abstract getAnnotation<T extends Internal.Annotation>(arg0: T): T;
        abstract getAnnotations(): Internal.Annotation[];
        abstract getDeclaredAnnotations(): Internal.Annotation[];
        abstract getType(): Internal.Type;
        isAnnotationPresent(arg0: typeof Internal.Annotation): boolean;
        get annotatedOwnerType(): Internal.AnnotatedType
        get annotations(): Internal.Annotation[]
        get declaredAnnotations(): Internal.Annotation[]
        get type(): Internal.Type
    }
    type AnnotatedType_ = AnnotatedType;
    class StainedGlassBlock extends Internal.AbstractGlassBlock implements Internal.BeaconBeamBlock {
        constructor($$0: Internal.DyeColor_, $$1: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getColor(): Internal.DyeColor;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        get color(): Internal.DyeColor
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type StainedGlassBlock_ = StainedGlassBlock;
    abstract class AbstractObject2ObjectFunction <K, V> implements Internal.Object2ObjectFunction<K, V>, Internal.Serializable {
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<K, V>;
        getOrDefault(arg0: any, arg1: V): V;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2ObjectFunction<V>;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2ObjectFunction<V>;
        containsKey(arg0: any): boolean;
        put(arg0: K, arg1: V): V;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Object2FloatFunction<K>;
        abstract get(arg0: any): V;
        remove(arg0: any): V;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2ObjectFunction<V>;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Object2LongFunction<K>;
        apply(arg0: K): V;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Object2ReferenceFunction<K, T>;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2ObjectFunction<V>;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Object2IntFunction<K>;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Object2ShortFunction<K>;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Object2DoubleFunction<K>;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2ObjectFunction<V>;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2ObjectFunction<T, V>;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2ObjectFunction<V>;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Object2ByteFunction<K>;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2ObjectFunction<T, V>;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2ObjectFunction<V>;
        size(): number;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Object2CharFunction<K>;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, V>;
        clear(): void;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Object2ObjectFunction<K, T>;
        defaultReturnValue(): V;
        static identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
    }
    type AbstractObject2ObjectFunction_<K, V> = AbstractObject2ObjectFunction<K, V>;
    class PageAttributes$OriginType extends Internal.AttributeValue {
        static readonly PRINTABLE: Internal.PageAttributes$OriginType;
        static readonly PHYSICAL: Internal.PageAttributes$OriginType;
    }
    type PageAttributes$OriginType_ = PageAttributes$OriginType;
    class WrapFactory {
        constructor()
        isJavaPrimitiveWrap(): boolean;
        setJavaPrimitiveWrap(value: boolean): void;
        wrap(cx: Internal.Context_, scope: Internal.Scriptable_, obj: any, staticType: typeof any): any;
        wrapJavaClass(cx: Internal.Context_, scope: Internal.Scriptable_, javaClass: typeof any): Internal.Scriptable;
        wrapAsJavaObject(cx: Internal.Context_, scope: Internal.Scriptable_, javaObject: any, staticType: typeof any): Internal.Scriptable;
        wrapNewObject(scope: Internal.Scriptable_, obj: any, cx: Internal.Context_): Internal.Scriptable;
        get javaPrimitiveWrap(): boolean
        set javaPrimitiveWrap(value: boolean)
    }
    type WrapFactory_ = WrapFactory;
    class TinkerStationBlock extends Internal.RetexturedTableBlock {
        constructor(builder: Internal.BlockBehaviour$Properties_, slotCount: number)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getSlotCount(): number;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        get slotCount(): number
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type TinkerStationBlock_ = TinkerStationBlock;
    abstract class MemorySessionImpl$ResourceList$ResourceCleanup {
        constructor()
        abstract cleanup(): void;
    }
    type MemorySessionImpl$ResourceList$ResourceCleanup_ = MemorySessionImpl$ResourceList$ResourceCleanup;
    interface INoTab {
        abstract shouldBeInTab(): boolean;
        (): boolean;
    }
    type INoTab_ = INoTab;
    abstract class RectangularShape implements Internal.Shape, Internal.Cloneable {
        clone(): any;
        abstract contains(arg0: number, arg1: number): boolean;
        getBounds(): Internal.Rectangle;
        getMaxX(): number;
        getMaxY(): number;
        intersects(arg0: Internal.Rectangle2D_): boolean;
        abstract isEmpty(): boolean;
        getCenterY(): number;
        getCenterX(): number;
        setFrameFromCenter(arg0: number, arg1: number, arg2: number, arg3: number): void;
        abstract contains(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        abstract getWidth(): number;
        getPathIterator(arg0: Internal.AffineTransform_, arg1: number): Internal.PathIterator;
        abstract intersects(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        setFrame(arg0: Internal.Rectangle2D_): void;
        abstract getBounds2D(): Internal.Rectangle2D;
        contains(arg0: Internal.Rectangle2D_): boolean;
        getMinX(): number;
        abstract getHeight(): number;
        getMinY(): number;
        setFrameFromCenter(arg0: Internal.Point2D_, arg1: Internal.Point2D_): void;
        abstract setFrame(arg0: number, arg1: number, arg2: number, arg3: number): void;
        abstract getPathIterator(arg0: Internal.AffineTransform_): Internal.PathIterator;
        setFrameFromDiagonal(arg0: number, arg1: number, arg2: number, arg3: number): void;
        contains(arg0: Internal.Point2D_): boolean;
        abstract getX(): number;
        abstract getY(): number;
        setFrame(arg0: Internal.Point2D_, arg1: Internal.Dimension2D_): void;
        getFrame(): Internal.Rectangle2D;
        setFrameFromDiagonal(arg0: Internal.Point2D_, arg1: Internal.Point2D_): void;
        get bounds(): Internal.Rectangle
        get maxX(): number
        get maxY(): number
        get empty(): boolean
        get centerY(): number
        get centerX(): number
        get width(): number
        set frame(arg0: Internal.Rectangle2D_)
        get bounds2D(): Internal.Rectangle2D
        get minX(): number
        get height(): number
        get minY(): number
        get x(): number
        get y(): number
        get frame(): Internal.Rectangle2D
    }
    type RectangularShape_ = RectangularShape;
    class InternalEnergyStorage extends Internal.SnapshotParticipant<number> implements Internal.EnergyStorage {
        constructor(capacity: number, maxReceive: number, maxExtract: number, energy: number)
        constructor(capacity: number, maxTransfer: number)
        constructor(capacity: number)
        constructor(capacity: number, maxReceive: number, maxExtract: number)
        insert(maxAmount: number, transaction: Internal.TransactionContext_): number;
        supportsInsertion(): boolean;
        internalProduceEnergy(produce: number): number;
        setEnergy(energy: number): void;
        simulateExtract(maxAmount: number): number;
        extract(maxAmount: number, transaction: Internal.TransactionContext_): number;
        write(nbt: Internal.CompoundTag_, name: string): Internal.CompoundTag;
        supportsExtraction(): boolean;
        setCapacity(capacity: number): void;
        getAmount(): number;
        /**
         * @deprecated
        */
        outputToSide(world: Internal.Level_, pos: BlockPos_, side: Internal.Direction_, max: number): void;
        write(nbt: Internal.CompoundTag_): Internal.CompoundTag;
        read(nbt: Internal.CompoundTag_): void;
        getSpace(): number;
        internalConsumeEnergy(consume: number): number;
        read(nbt: Internal.CompoundTag_, name: string): void;
        getCapacity(): number;
        set energy(energy: number)
        set capacity(capacity: number)
        get amount(): number
        get space(): number
        get capacity(): number
        capacity: number;
        readonly maxExtract: number;
        amount: number;
        readonly maxReceive: number;
    }
    type InternalEnergyStorage_ = InternalEnergyStorage;
    interface InstanceHandle {
        abstract setChanged(): void;
        abstract isVisible(): boolean;
        abstract setDeleted(): void;
        abstract setVisible(arg0: boolean): void;
        get visible(): boolean
        set visible(arg0: boolean)
    }
    type InstanceHandle_ = InstanceHandle;
    interface LootPoolBuilderExtension {
        name(name: string): Internal.LootPool$Builder;
    }
    type LootPoolBuilderExtension_ = LootPoolBuilderExtension;
    class CropState extends Internal.Enum<Internal.CropState> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf(name: string): Internal.CropState;
        getSerializedName(): string;
        hasPlant(): boolean;
        static values(): Internal.CropState[];
        hasSticks(): boolean;
        get serializedName(): string
        static readonly SINGLE_STICKS: Internal.CropState;
        static readonly DOUBLE_STICKS: Internal.CropState;
        static readonly PLANT_STICKS: Internal.CropState;
        static readonly PLANT: Internal.CropState;
    }
    type CropState_ = "double_sticks" | "single_sticks" | CropState | "plant" | "plant_sticks";
    class TrimPattern extends Internal.Record {
        constructor($$0: ResourceLocation_, $$1: Internal.Holder_<Internal.Item>, $$2: net.minecraft.network.chat.Component_)
        description(): net.minecraft.network.chat.Component;
        assetId(): ResourceLocation;
        copyWithStyle($$0: Internal.Holder_<Internal.TrimMaterial>): net.minecraft.network.chat.Component;
        templateItem(): Internal.Holder<Internal.Item>;
        static readonly CODEC: Internal.Codec<Internal.Holder<Internal.TrimPattern>>;
        static readonly DIRECT_CODEC: Internal.Codec<Internal.TrimPattern>;
    }
    type TrimPattern_ = Special.TrimPattern | TrimPattern;
    interface LevelExtension {
        getAllLoadedEntities(level: Internal.Level_): Internal.Iterable<Internal.Entity>;
        abstract flywheel$getAllLoadedEntities(): Internal.Iterable<Internal.Entity>;
        (): Internal.Iterable_<Internal.Entity>;
    }
    type LevelExtension_ = LevelExtension;
    interface ItemFrameAccessor {
        abstract create$getFrameItemStack(): Internal.ItemStack;
        (): Internal.ItemStack_;
    }
    type ItemFrameAccessor_ = ItemFrameAccessor;
    class ChorusPlantBlock extends Internal.PipeBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getStateForPlacement($$0: Internal.BlockGetter_, $$1: BlockPos_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type ChorusPlantBlock_ = ChorusPlantBlock;
    class InfernalSpireColumnFeature extends Internal.Feature<Internal.ColumnFeatureConfiguration> {
        constructor(codec: Internal.Codec_<Internal.ColumnFeatureConfiguration>)
    }
    type InfernalSpireColumnFeature_ = InfernalSpireColumnFeature;
    class JacarandaLeavesBlock extends Internal.LeavesBlock {
        constructor(p_273704_: Internal.BlockBehaviour$Properties_)
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<Internal.ItemStack>;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type JacarandaLeavesBlock_ = JacarandaLeavesBlock;
    interface IoSupplier <T> {
        create($$0: Internal.Path_): Internal.IoSupplier<Internal.InputStream>;
        abstract get(): T;
        create($$0: Internal.ZipFile_, $$1: Internal.ZipEntry_): Internal.IoSupplier<Internal.InputStream>;
        (): T;
    }
    type IoSupplier_<T> = IoSupplier<T>;
    class BlobFoliagePlacer extends Internal.FoliagePlacer {
        constructor($$0: Internal.IntProvider_, $$1: Internal.IntProvider_, $$2: number)
        static readonly CODEC: Internal.Codec<Internal.BlobFoliagePlacer>;
    }
    type BlobFoliagePlacer_ = BlobFoliagePlacer;
    class TagKey <T> extends Internal.Record {
        constructor($$0: Internal.ResourceKey_<Internal.Registry<T>>, $$1: ResourceLocation_)
        static create<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>, $$1: ResourceLocation_): Internal.TagKey<T>;
        location(): ResourceLocation;
        static codec<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.Codec<Internal.TagKey<T>>;
        cast<E>($$0: Internal.ResourceKey_<Internal.Registry<E>>): Internal.Optional<Internal.TagKey<E>>;
        registry(): Internal.ResourceKey<Internal.Registry<T>>;
        static hashedCodec<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.Codec<Internal.TagKey<T>>;
        isFor($$0: Internal.ResourceKey_<Internal.Registry<any>>): boolean;
    }
    type TagKey_<T> = TagKey<T>;
    class PackageOrderWithCrafts$CraftingEntry extends Internal.Record {
        constructor(pattern: Internal.PackageOrder_, count: number)
        count(): number;
        write(buffer: Internal.FriendlyByteBuf_): void;
        write(): Internal.CompoundTag;
        static read(tag: Internal.CompoundTag_): Internal.PackageOrderWithCrafts$CraftingEntry;
        pattern(): Internal.PackageOrder;
        static read(buffer: Internal.FriendlyByteBuf_): Internal.PackageOrderWithCrafts$CraftingEntry;
    }
    type PackageOrderWithCrafts$CraftingEntry_ = PackageOrderWithCrafts$CraftingEntry;
    interface IntIterator extends Internal.PrimitiveIterator$OfInt {
        forEachRemaining(arg0: any): void;
        remove(): void;
        /**
         * @deprecated
        */
        next(): any;
        skip(arg0: number): number;
        forEachRemaining(arg0: it.unimi.dsi.fastutil.ints.IntConsumer_): void;
        forEachRemaining(arg0: Internal.IntConsumer_): void;
        abstract hasNext(): boolean;
        /**
         * @deprecated
        */
        forEachRemaining(arg0: Internal.Consumer_<number>): void;
        abstract nextInt(): number;
    }
    type IntIterator_ = IntIterator;
    class GearshiftBlock extends Internal.AbstractEncasedShaftBlock implements Internal.IBE<Internal.SplitShaftBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        detachKinetics(worldIn: Internal.Level_, pos: BlockPos_, reAttachNextTick: boolean): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.SplitShaftBlockEntity>;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.SplitShaftBlockEntity>): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.SplitShaftBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.SplitShaftBlockEntity;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getBlockEntityClass(): typeof Internal.SplitShaftBlockEntity;
        setDestroySpeed(v: number): void;
        getBlockEntityType(): Internal.BlockEntityType<Internal.SplitShaftBlockEntity>;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        showCapacityWithAnnotation(): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get blockEntityClass(): typeof Internal.SplitShaftBlockEntity
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.SplitShaftBlockEntity>
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        static readonly POWERED: Internal.BooleanProperty;
    }
    type GearshiftBlock_ = GearshiftBlock;
    interface ToIntBiFunction <T, U> {
        abstract applyAsInt(arg0: T, arg1: U): number;
        (arg0: T, arg1: U): number;
    }
    type ToIntBiFunction_<T, U> = ToIntBiFunction<T, U>;
    class AxolotlAttackablesSensor extends Internal.NearestVisibleLivingEntitySensor {
        constructor()
        static readonly TARGET_DETECTION_DISTANCE: 8.0;
    }
    type AxolotlAttackablesSensor_ = AxolotlAttackablesSensor;
    class SurfaceRelativeThresholdFilter extends Internal.PlacementFilter {
        static of($$0: Internal.Heightmap$Types_, $$1: number, $$2: number): Internal.SurfaceRelativeThresholdFilter;
        static readonly CODEC: Internal.Codec<Internal.SurfaceRelativeThresholdFilter>;
    }
    type SurfaceRelativeThresholdFilter_ = SurfaceRelativeThresholdFilter;
    class ModifiableStaffItem extends Internal.ModifiableItem {
        constructor(properties: Internal.Item$Properties_, toolDefinition: Internal.ToolDefinition_, tab: Internal.ResourceKey_<Internal.CreativeModeTab>)
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static getDisplayStack(item: Internal.Item_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLocalizedName(): net.minecraft.network.chat.Component;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        /**
         * @deprecated
        */
        getStatInformation(tool: Internal.IToolStackView_, player: Internal.Player_, tooltips: Internal.List_<net.minecraft.network.chat.Component>, key: slimeknights.tconstruct.library.utils.TooltipKey_, tooltipFlag: Internal.TooltipFlag_): Internal.List<net.minecraft.network.chat.Component>;
        setAttackDamage(attackDamage: number): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static setRarity(volatileData: Internal.ModDataNBT_, rarity: Internal.Rarity_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get localizedName(): net.minecraft.network.chat.Component
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ModifiableStaffItem_ = ModifiableStaffItem;
    class ShulkerBoxBlockEntity$AnimationStatus extends Internal.Enum<Internal.ShulkerBoxBlockEntity$AnimationStatus> {
        static valueOf($$0: string): Internal.ShulkerBoxBlockEntity$AnimationStatus;
        static values(): Internal.ShulkerBoxBlockEntity$AnimationStatus[];
        static readonly OPENING: Internal.ShulkerBoxBlockEntity$AnimationStatus;
        static readonly CLOSED: Internal.ShulkerBoxBlockEntity$AnimationStatus;
        static readonly CLOSING: Internal.ShulkerBoxBlockEntity$AnimationStatus;
        static readonly OPENED: Internal.ShulkerBoxBlockEntity$AnimationStatus;
    }
    type ShulkerBoxBlockEntity$AnimationStatus_ = "opening" | ShulkerBoxBlockEntity$AnimationStatus | "closing" | "closed" | "opened";
    class ProviderPipeBlock extends Internal.ContainerAdjacentNetworkedPipeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
    }
    type ProviderPipeBlock_ = ProviderPipeBlock;
    interface IOpenableScreen extends Internal.Runnable {
        closeGui(): void;
        abstract openGui(): void;
        closeContextMenu(): void;
        closeGui(openPrevScreen: boolean): void;
        run(): void;
        openAfter(runnable: Internal.Runnable_): Internal.Runnable;
        openGuiLater(): void;
        (): void;
    }
    type IOpenableScreen_ = IOpenableScreen;
    class ScytheItem extends Internal.DiggerItem implements Internal.CustomHitParticleItem, Internal.CustomHitSoundItem, Internal.ArsenalWeaponItem {
        constructor(material: Internal.Tier_, damage: number, speed: number, settings: Internal.Item$Properties_)
        playHitSound(player: Internal.Player_): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        spawnHitParticles(player: Internal.Player_): void;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ScytheItem_ = ScytheItem;
    class ByteProcessor$IndexOfProcessor implements Internal.ByteProcessor {
        constructor(arg0: number)
        process(arg0: number): boolean;
    }
    type ByteProcessor$IndexOfProcessor_ = ByteProcessor$IndexOfProcessor;
    interface BlockStatePathingCache {
        abstract getNeighborPathNodeType(): Internal.BlockPathTypes;
        abstract getPathNodeType(): Internal.BlockPathTypes;
        get neighborPathNodeType(): Internal.BlockPathTypes
        get pathNodeType(): Internal.BlockPathTypes
    }
    type BlockStatePathingCache_ = BlockStatePathingCache;
    class MessageSignature$Packed extends Internal.Record {
        constructor($$0: number, $$1: Internal.MessageSignature_)
        constructor($$0: number)
        constructor($$0: Internal.MessageSignature_)
        id(): number;
        static read($$0: Internal.FriendlyByteBuf_): Internal.MessageSignature$Packed;
        unpack($$0: Internal.MessageSignatureCache_): Internal.Optional<Internal.MessageSignature>;
        fullSignature(): Internal.MessageSignature;
        static write($$0: Internal.FriendlyByteBuf_, $$1: Internal.MessageSignature$Packed_): void;
        static readonly FULL_SIGNATURE: -1;
    }
    type MessageSignature$Packed_ = MessageSignature$Packed;
    class ConstantInt extends Internal.IntProvider {
        static of($$0: number): Internal.ConstantInt;
        getValue(): number;
        get value(): number
        static readonly ZERO: Internal.ConstantInt;
        static readonly CODEC: Internal.Codec<Internal.ConstantInt>;
    }
    type ConstantInt_ = ConstantInt;
    class EndDragonFight$Data extends Internal.Record {
        constructor($$0: boolean, $$1: boolean, $$2: boolean, $$3: boolean, $$4: Internal.Optional_<Internal.UUID>, $$5: Internal.Optional_<BlockPos>, $$6: Internal.Optional_<Internal.List<number>>)
        dragonUUID(): Internal.Optional<Internal.UUID>;
        dragonKilled(): boolean;
        previouslyKilled(): boolean;
        exitPortalLocation(): Internal.Optional<BlockPos>;
        gateways(): Internal.Optional<Internal.List<number>>;
        needsStateScanning(): boolean;
        isRespawning(): boolean;
        get respawning(): boolean
        static readonly CODEC: Internal.Codec<Internal.EndDragonFight$Data>;
        static readonly DEFAULT: Internal.EndDragonFight$Data;
    }
    type EndDragonFight$Data_ = EndDragonFight$Data;
    class BeltBlockEntity$RenderData extends Internal.Record {
        constructor(casingType: Internal.BeltBlockEntity$CasingType_, covered: boolean)
        casingType(): Internal.BeltBlockEntity$CasingType;
        covered(): boolean;
    }
    type BeltBlockEntity$RenderData_ = BeltBlockEntity$RenderData;
    interface FinishedRecipe {
        abstract serializeRecipeData(arg0: Internal.JsonObject_): void;
        abstract getId(): ResourceLocation;
        abstract getAdvancementId(): ResourceLocation;
        abstract getType(): Internal.RecipeSerializer<any>;
        abstract serializeAdvancement(): Internal.JsonObject;
        serializeRecipe(): Internal.JsonObject;
        get id(): ResourceLocation
        get advancementId(): ResourceLocation
        get type(): Internal.RecipeSerializer<any>
    }
    type FinishedRecipe_ = FinishedRecipe;
    class RuleBasedBlockStateProvider extends Internal.Record {
        constructor($$0: Internal.BlockStateProvider_, $$1: Internal.List_<Internal.RuleBasedBlockStateProvider$Rule>)
        getState($$0: Internal.WorldGenLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_): Internal.BlockState;
        static simple($$0: Internal.Block_): Internal.RuleBasedBlockStateProvider;
        fallback(): Internal.BlockStateProvider;
        static simple($$0: Internal.BlockStateProvider_): Internal.RuleBasedBlockStateProvider;
        rules(): Internal.List<Internal.RuleBasedBlockStateProvider$Rule>;
        static readonly CODEC: Internal.Codec<Internal.RuleBasedBlockStateProvider>;
    }
    type RuleBasedBlockStateProvider_ = RuleBasedBlockStateProvider;
    class MinecartTNT extends Internal.AbstractMinecart {
        constructor($$0: Internal.EntityType_<Internal.MinecartTNT>, $$1: Internal.Level_)
        constructor($$0: Internal.Level_, $$1: number, $$2: number, $$3: number)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        getMaxSpeedOnRail(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        primeFuse(): void;
        isPrimed(): boolean;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getFuse(): number;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        get maxSpeedOnRail(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        get primed(): boolean
        get fuse(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
    }
    type MinecartTNT_ = MinecartTNT;
    interface AmbiguityConsumer <S> {
        abstract ambiguous(arg0: Internal.CommandNode_<S>, arg1: Internal.CommandNode_<S>, arg2: Internal.CommandNode_<S>, arg3: Internal.Collection_<string>): void;
        (arg0: Internal.CommandNode<S>, arg1: Internal.CommandNode<S>, arg2: Internal.CommandNode<S>, arg3: Internal.Collection<string>): void;
    }
    type AmbiguityConsumer_<S> = AmbiguityConsumer<S>;
    class MeltingRecipe$Serializer <T extends Internal.MeltingRecipe> extends Internal.MeltingRecipe$AbstractSerializer<T> {
        constructor(factory: any_<T>)
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.MeltingRecipe;
    }
    type MeltingRecipe$Serializer_<T extends Internal.MeltingRecipe> = MeltingRecipe$Serializer<T>;
    class Collections$UnmodifiableCollection <E> implements Internal.Collection<E>, Internal.Serializable {
        add(arg0: E): boolean;
        forEach(arg0: Internal.Consumer_<E>): void;
        toArray<T>(arg0: T[]): T[];
        remove(arg0: any): boolean;
        parallelStream(): Internal.Stream<E>;
        isEmpty(): boolean;
        toArray(): any[];
        iterator(): Internal.Iterator<E>;
        retainAll(arg0: Internal.Collection_<any>): boolean;
        size(): number;
        containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        stream(): Internal.Stream<E>;
        removeAll(arg0: Internal.Collection_<any>): boolean;
        clear(): void;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        spliterator(): Internal.Spliterator<E>;
        contains(arg0: any): boolean;
        addAll(arg0: Internal.Collection_<E>): boolean;
        get empty(): boolean
    }
    type Collections$UnmodifiableCollection_<E> = Collections$UnmodifiableCollection<E>;
    class TooltipRenderedBlockItem extends Internal.TooltipBlockItem {
        constructor(block: Internal.Block_, description: net.minecraft.network.chat.Component_, properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type TooltipRenderedBlockItem_ = TooltipRenderedBlockItem;
    class AutoCookingUpgradeWrapper$AutoSmeltingUpgradeWrapper extends Internal.AutoCookingUpgradeWrapper<Internal.AutoCookingUpgradeWrapper$AutoSmeltingUpgradeWrapper, Internal.AutoSmeltingUpgradeItem, Internal.SmeltingRecipe> {
        constructor(storageWrapper: Internal.IStorageWrapper_, upgrade: Internal.ItemStack_, upgradeSaveHandler: Internal.Consumer_<Internal.ItemStack>)
        canBeDisabled(): boolean;
        hideSettingsTab(): boolean;
        onAdded(): void;
    }
    type AutoCookingUpgradeWrapper$AutoSmeltingUpgradeWrapper_ = AutoCookingUpgradeWrapper$AutoSmeltingUpgradeWrapper;
    class ContainerEvent extends Internal.ComponentEvent {
        constructor(arg0: Internal.Component_, arg1: number, arg2: Internal.Component_)
        getChild(): Internal.Component;
        getContainer(): Internal.Container;
        get child(): Internal.Component
        get container(): Internal.Container
        static readonly CONTAINER_FIRST: 300;
        static readonly CONTAINER_LAST: 301;
        static readonly COMPONENT_ADDED: 300;
        static readonly COMPONENT_REMOVED: 301;
    }
    type ContainerEvent_ = ContainerEvent;
    abstract class StructurePoolElement {
        abstract getBoundingBox(arg0: Internal.StructureTemplateManager_, arg1: BlockPos_, arg2: Internal.Rotation_): Internal.BoundingBox;
        static legacy($$0: string, $$1: Internal.Holder_<Internal.StructureProcessorList>): Internal.Function<Internal.StructureTemplatePool$Projection, Internal.LegacySinglePoolElement>;
        abstract getType(): Internal.StructurePoolElementType<any>;
        abstract getShuffledJigsawBlocks(arg0: Internal.StructureTemplateManager_, arg1: BlockPos_, arg2: Internal.Rotation_, arg3: Internal.RandomSource_): Internal.List<Internal.StructureTemplate$StructureBlockInfo>;
        static single($$0: string): Internal.Function<Internal.StructureTemplatePool$Projection, Internal.SinglePoolElement>;
        handleDataMarker($$0: Internal.LevelAccessor_, $$1: Internal.StructureTemplate$StructureBlockInfo_, $$2: BlockPos_, $$3: Internal.Rotation_, $$4: Internal.RandomSource_, $$5: Internal.BoundingBox_): void;
        abstract getSize(arg0: Internal.StructureTemplateManager_, arg1: Internal.Rotation_): Vec3i;
        getGroundLevelDelta(): number;
        abstract place(arg0: Internal.StructureTemplateManager_, arg1: Internal.WorldGenLevel_, arg2: Internal.StructureManager_, arg3: Internal.ChunkGenerator_, arg4: BlockPos_, arg5: BlockPos_, arg6: Internal.Rotation_, arg7: Internal.BoundingBox_, arg8: Internal.RandomSource_, arg9: boolean): boolean;
        setProjection($$0: Internal.StructureTemplatePool$Projection_): this;
        static legacy($$0: string): Internal.Function<Internal.StructureTemplatePool$Projection, Internal.LegacySinglePoolElement>;
        getProjection(): Internal.StructureTemplatePool$Projection;
        static empty(): Internal.Function<Internal.StructureTemplatePool$Projection, Internal.EmptyPoolElement>;
        static list($$0: Internal.List_<Internal.Function<Internal.StructureTemplatePool$Projection, Internal.StructurePoolElement>>): Internal.Function<Internal.StructureTemplatePool$Projection, Internal.ListPoolElement>;
        static single($$0: string, $$1: Internal.Holder_<Internal.StructureProcessorList>): Internal.Function<Internal.StructureTemplatePool$Projection, Internal.SinglePoolElement>;
        static feature($$0: Internal.Holder_<Internal.PlacedFeature>): Internal.Function<Internal.StructureTemplatePool$Projection, Internal.FeaturePoolElement>;
        get type(): Internal.StructurePoolElementType<any>
        get groundLevelDelta(): number
        set projection($$0: Internal.StructureTemplatePool$Projection_)
        get projection(): Internal.StructureTemplatePool$Projection
        static readonly CODEC: Internal.Codec<Internal.StructurePoolElement>;
    }
    type StructurePoolElement_ = StructurePoolElement;
    class ModifierMaterialRepairSerializer <T extends Internal.Recipe<any> & Internal.ModifierMaterialRepairSerializer$IModifierMaterialRepairRecipe> extends Internal.LoggingRecipeSerializer<T> {
        constructor(factory: any_<T>)
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): T;
    }
    type ModifierMaterialRepairSerializer_<T extends Internal.Recipe<any> & Internal.ModifierMaterialRepairSerializer$IModifierMaterialRepairRecipe> = ModifierMaterialRepairSerializer<T>;
    class RuinedPortalStructure extends Internal.Structure {
        constructor($$0: Internal.Structure$StructureSettings_, $$1: any_)
        constructor($$0: Internal.Structure$StructureSettings_, $$1: Internal.List_<any>)
        method_38676($$0: Internal.Structure$GenerationContext_): Internal.Optional<Internal.Structure$GenerationStub>;
        static readonly CODEC: Internal.Codec<Internal.RuinedPortalStructure>;
    }
    type RuinedPortalStructure_ = RuinedPortalStructure;
    class ClientboundSetChunkCacheCenterPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: number, $$1: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getX(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getZ(): number;
        isSkippable(): boolean;
        get x(): number
        get z(): number
        get skippable(): boolean
    }
    type ClientboundSetChunkCacheCenterPacket_ = ClientboundSetChunkCacheCenterPacket;
    class ListCodec <A> implements Internal.Codec<Internal.List<A>> {
        constructor(arg0: Internal.Codec_<A>)
        optionalFieldOf(arg0: string, arg1: Internal.List_<A>): Internal.MapCodec<Internal.List<A>>;
        dispatchMap<E>(arg0: Internal.Function_<E, Internal.List<A>>, arg1: Internal.Function_<Internal.List<A>, Internal.Codec<E>>): Internal.MapCodec<E>;
        static empty<A>(): Internal.MapEncoder<A>;
        promotePartial(arg0: Internal.Consumer_<string>): Internal.Codec<Internal.List<A>>;
        static error<A>(arg0: string): Internal.Encoder<A>;
        static unit<A>(arg0: Internal.Supplier_<A>): Internal.Codec<A>;
        parse<T>(arg0: Internal.Dynamic_<T>): Internal.DataResult<Internal.List<A>>;
        orElse(arg0: Internal.UnaryOperator_<string>, arg1: Internal.List_<A>): Internal.Codec<Internal.List<A>>;
        static floatRange(arg0: number, arg1: number): Internal.Codec<number>;
        comap<B>(arg0: Internal.Function_<B, Internal.List<A>>): Internal.Encoder<B>;
        withLifecycle(arg0: Internal.Lifecycle_): Internal.Codec<Internal.List<A>>;
        decode<T>(arg0: Internal.Dynamic_<T>): Internal.DataResult<com.mojang.datafixers.util.Pair<Internal.List<A>, T>>;
        stable(): Internal.Codec<Internal.List<A>>;
        partialDispatch<E>(arg0: string, arg1: Internal.Function_<E, Internal.DataResult<Internal.List<A>>>, arg2: Internal.Function_<Internal.List<A>, Internal.DataResult<Internal.Codec<E>>>): Internal.Codec<E>;
        static ofBoxed<A>(arg0: Internal.Decoder$Boxed_<A>): Internal.Decoder<A>;
        dispatch<E>(arg0: string, arg1: Internal.Function_<E, Internal.List<A>>, arg2: Internal.Function_<Internal.List<A>, Internal.Codec<E>>): Internal.Codec<E>;
        encode<T>(arg0: Internal.List_<A>, arg1: Internal.DynamicOps_<T>, arg2: T): Internal.DataResult<T>;
        orElseGet(arg0: Internal.UnaryOperator_<string>, arg1: Internal.Supplier_<Internal.List<A>>): Internal.Codec<Internal.List<A>>;
        optionalFieldOf(arg0: string, arg1: Internal.List_<A>, arg2: Internal.Lifecycle_): Internal.MapCodec<Internal.List<A>>;
        map<B>(arg0: Internal.Function_<Internal.List<A>, B>): Internal.Decoder<B>;
        terminal(): Internal.Decoder$Terminal<Internal.List<A>>;
        flatMap<B>(arg0: Internal.Function_<Internal.List<A>, Internal.DataResult<B>>): Internal.Decoder<B>;
        static unit<A>(arg0: A): Internal.Codec<A>;
        static intRange(arg0: number, arg1: number): Internal.Codec<number>;
        comapFlatMap<S>(arg0: Internal.Function_<Internal.List<A>, Internal.DataResult<S>>, arg1: Internal.Function_<S, Internal.List<A>>): Internal.Codec<S>;
        encodeStart<T>(arg0: Internal.DynamicOps_<T>, arg1: Internal.List_<A>): Internal.DataResult<T>;
        simple(): Internal.Decoder$Simple<Internal.List<A>>;
        static pair<F, S>(arg0: Internal.Codec_<F>, arg1: Internal.Codec_<S>): Internal.Codec<com.mojang.datafixers.util.Pair<F, S>>;
        static either<F, S>(arg0: Internal.Codec_<F>, arg1: Internal.Codec_<S>): Internal.Codec<Internal.Either<F, S>>;
        static checkRange<N extends number & Internal.Comparable<N>>(arg0: N, arg1: N): Internal.Function<N, Internal.DataResult<N>>;
        flatXmap<S>(arg0: Internal.Function_<Internal.List<A>, Internal.DataResult<S>>, arg1: Internal.Function_<S, Internal.DataResult<Internal.List<A>>>): Internal.Codec<S>;
        flatComapMap<S>(arg0: Internal.Function_<Internal.List<A>, S>, arg1: Internal.Function_<S, Internal.DataResult<Internal.List<A>>>): Internal.Codec<S>;
        static unboundedMap<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>): Internal.UnboundedMapCodec<K, V>;
        fieldOf(arg0: string): Internal.MapDecoder<any>;
        optionalFieldOf(arg0: string): Internal.MapCodec<Internal.Optional<Internal.List<A>>>;
        static of<A>(arg0: Internal.Encoder_<A>, arg1: Internal.Decoder_<A>, arg2: string): Internal.Codec<A>;
        mapResult(arg0: Internal.Codec$ResultFunction_<Internal.List<A>>): Internal.Codec<Internal.List<A>>;
        parse<T>(arg0: Internal.DynamicOps_<T>, arg1: T): Internal.DataResult<Internal.List<A>>;
        dispatch<E>(arg0: Internal.Function_<E, Internal.List<A>>, arg1: Internal.Function_<Internal.List<A>, Internal.Codec<E>>): Internal.Codec<E>;
        orElse(arg0: Internal.List_<A>): Internal.Codec<Internal.List<A>>;
        static ofSimple<A>(arg0: Internal.Decoder$Simple_<A>): Internal.Decoder<A>;
        static mapEither<F, S>(arg0: Internal.MapCodec_<F>, arg1: Internal.MapCodec_<S>): Internal.MapCodec<Internal.Either<F, S>>;
        optionalFieldOf(arg0: string, arg1: Internal.Lifecycle_, arg2: Internal.List_<A>, arg3: Internal.Lifecycle_): Internal.MapCodec<Internal.List<A>>;
        static doubleRange(arg0: number, arg1: number): Internal.Codec<number>;
        static optionalField<F>(arg0: string, arg1: Internal.Codec_<F>): Internal.MapCodec<Internal.Optional<F>>;
        static simpleMap<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>, arg2: Internal.Keyable_): Internal.SimpleMapCodec<K, V>;
        static ofTerminal<A>(arg0: Internal.Decoder$Terminal_<A>): Internal.Decoder<A>;
        encode(arg0: any, arg1: Internal.DynamicOps_<any>, arg2: any): Internal.DataResult<any>;
        deprecated(arg0: number): Internal.Codec<Internal.List<A>>;
        static list<E>(arg0: Internal.Codec_<E>): Internal.Codec<Internal.List<E>>;
        flatComap<B>(arg0: Internal.Function_<B, Internal.DataResult<Internal.List<A>>>): Internal.Encoder<B>;
        dispatchMap<E>(arg0: string, arg1: Internal.Function_<E, Internal.List<A>>, arg2: Internal.Function_<Internal.List<A>, Internal.Codec<E>>): Internal.MapCodec<E>;
        boxed(): Internal.Decoder$Boxed<Internal.List<A>>;
        orElseGet(arg0: Internal.Supplier_<Internal.List<A>>): Internal.Codec<Internal.List<A>>;
        static of<A>(arg0: Internal.MapEncoder_<A>, arg1: Internal.MapDecoder_<A>): Internal.MapCodec<A>;
        orElseGet(arg0: Internal.Consumer_<string>, arg1: Internal.Supplier_<Internal.List<A>>): Internal.Codec<Internal.List<A>>;
        static of<A>(arg0: Internal.Encoder_<A>, arg1: Internal.Decoder_<A>): Internal.Codec<A>;
        listOf(): Internal.Codec<Internal.List<Internal.List<A>>>;
        orElse(arg0: Internal.Consumer_<string>, arg1: Internal.List_<A>): Internal.Codec<Internal.List<A>>;
        xmap<S>(arg0: Internal.Function_<Internal.List<A>, S>, arg1: Internal.Function_<S, Internal.List<A>>): Internal.Codec<S>;
        static of<A>(arg0: Internal.MapEncoder_<A>, arg1: Internal.MapDecoder_<A>, arg2: Internal.Supplier_<string>): Internal.MapCodec<A>;
        static compoundList<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>): Internal.Codec<Internal.List<com.mojang.datafixers.util.Pair<K, V>>>;
        decode<T>(arg0: Internal.DynamicOps_<T>, arg1: T): Internal.DataResult<com.mojang.datafixers.util.Pair<Internal.List<A>, T>>;
        static mapPair<F, S>(arg0: Internal.MapCodec_<F>, arg1: Internal.MapCodec_<S>): Internal.MapCodec<com.mojang.datafixers.util.Pair<F, S>>;
        dispatchStable<E>(arg0: Internal.Function_<E, Internal.List<A>>, arg1: Internal.Function_<Internal.List<A>, Internal.Codec<E>>): Internal.Codec<E>;
    }
    type ListCodec_<A> = ListCodec<A>;
    class RecipeComponentValue <T> implements Internal.Map$Entry<Internal.RecipeKey<T>, T>, Internal.WrappedJS {
        constructor(key: Internal.RecipeKey_<T>, index: number)
        static comparingByKey<K, V>(arg0: Internal.Comparator_<K>): Internal.Comparator<Internal.Map$Entry<K, V>>;
        shouldWrite(): boolean;
        replaceInput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        isOutput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_): boolean;
        getKey(): Internal.RecipeKey<T>;
        isInput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_): boolean;
        getIndex(): number;
        copy(): this;
        checkEmpty(): string;
        static comparingByValue<K, V extends Internal.Comparable<any>>(): Internal.Comparator<Internal.Map$Entry<K, V>>;
        write(): void;
        static copyOf<K, V>(arg0: Internal.Map$Entry_<K, V>): Internal.Map$Entry<K, V>;
        replaceOutput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getValue(): T;
        static comparingByKey<K extends Internal.Comparable<any>, V>(): Internal.Comparator<Internal.Map$Entry<K, V>>;
        static comparingByValue<K, V>(arg0: Internal.Comparator_<V>): Internal.Comparator<Internal.Map$Entry<K, V>>;
        setValue(newValue: T): T;
        get key(): Internal.RecipeKey<T>
        get index(): number
        get value(): T
        set value(newValue: T)
        readonly index: number;
        value: T;
        readonly key: Internal.RecipeKey<T>;
        static readonly EMPTY_ARRAY: Internal.RecipeComponentValue<any>[];
        write: boolean;
    }
    type RecipeComponentValue_<T> = RecipeComponentValue<T>;
    interface IGridVisitor {
        abstract visitNode(arg0: Internal.IGridNode_): boolean;
        (arg0: Internal.IGridNode): boolean;
    }
    type IGridVisitor_ = IGridVisitor;
    class CeilingHangingCanvasSignBlock extends Internal.CeilingHangingSignBlock implements Internal.CanvasSign {
        constructor(backgroundColor: Internal.DyeColor_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        isDarkBackground(): boolean;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getBackgroundColor(): Internal.DyeColor;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get darkBackground(): boolean
        get mod(): string
        set destroySpeed(v: number)
        get backgroundColor(): Internal.DyeColor
    }
    type CeilingHangingCanvasSignBlock_ = CeilingHangingCanvasSignBlock;
    class FluidAttributes {
        getLuminosity(stack: Internal.FluidStack_): number;
        getStillTexture(level: Internal.BlockAndTintGetter_, pos: BlockPos_): ResourceLocation;
        getFillSound(stack: Internal.FluidStack_): Internal.SoundEvent;
        getFlowingTexture(): ResourceLocation;
        getOverlayTexture(): ResourceLocation;
        static builder(stillTexture: ResourceLocation_, flowingTexture: ResourceLocation_): Internal.FluidAttributes$Builder;
        isGaseous(): boolean;
        getLuminosity(): number;
        getDensity(level: Internal.BlockAndTintGetter_, pos: BlockPos_): number;
        getColor(): number;
        getEmptySound(level: Internal.BlockAndTintGetter_, pos: BlockPos_): Internal.SoundEvent;
        getTranslationKey(stack: Internal.FluidStack_): string;
        getEmptySound(stack: Internal.FluidStack_): Internal.SoundEvent;
        getTemperature(stack: Internal.FluidStack_): number;
        getDensity(): number;
        isGaseous(level: Internal.BlockAndTintGetter_, pos: BlockPos_): boolean;
        getTemperature(level: Internal.BlockAndTintGetter_, pos: BlockPos_): number;
        getTextures(): Internal.Stream<ResourceLocation>;
        getBlock(reader: Internal.BlockAndTintGetter_, pos: BlockPos_, state: Internal.FluidState_): Internal.BlockState;
        getViscosity(stack: Internal.FluidStack_): number;
        getStillTexture(): ResourceLocation;
        getStateForPlacement(reader: Internal.BlockAndTintGetter_, pos: BlockPos_, state: Internal.FluidStack_): Internal.FluidState;
        getRarity(): Internal.Rarity;
        getBucket(stack: Internal.FluidStack_): Internal.ItemStack;
        getFlowingTexture(level: Internal.BlockAndTintGetter_, pos: BlockPos_): ResourceLocation;
        getFlowingTexture(stack: Internal.FluidStack_): ResourceLocation;
        isLighterThanAir(): boolean;
        getDisplayName(stack: Internal.FluidStack_): net.minecraft.network.chat.Component;
        getTranslationKey(): string;
        getRarity(level: Internal.BlockAndTintGetter_, pos: BlockPos_): Internal.Rarity;
        getFillSound(): Internal.SoundEvent;
        getViscosity(level: Internal.BlockAndTintGetter_, pos: BlockPos_): number;
        vaporize(player: Internal.Player_, worldIn: Internal.Level_, pos: BlockPos_, fluidStack: Internal.FluidStack_): void;
        canBePlacedInWorld(reader: Internal.BlockAndTintGetter_, pos: BlockPos_, state: Internal.FluidStack_): boolean;
        getColor(level: Internal.BlockAndTintGetter_, pos: BlockPos_): number;
        getDensity(stack: Internal.FluidStack_): number;
        isGaseous(stack: Internal.FluidStack_): boolean;
        canBePlacedInWorld(reader: Internal.BlockAndTintGetter_, pos: BlockPos_, state: Internal.FluidState_): boolean;
        getTemperature(): number;
        getEmptySound(): Internal.SoundEvent;
        getLuminosity(level: Internal.BlockAndTintGetter_, pos: BlockPos_): number;
        getStillTexture(stack: Internal.FluidStack_): ResourceLocation;
        getFillSound(level: Internal.BlockAndTintGetter_, pos: BlockPos_): Internal.SoundEvent;
        getViscosity(): number;
        getColor(stack: Internal.FluidStack_): number;
        getRarity(stack: Internal.FluidStack_): Internal.Rarity;
        get flowingTexture(): ResourceLocation
        get overlayTexture(): ResourceLocation
        get gaseous(): boolean
        get luminosity(): number
        get color(): number
        get density(): number
        get textures(): Internal.Stream<ResourceLocation>
        get stillTexture(): ResourceLocation
        get rarity(): Internal.Rarity
        get lighterThanAir(): boolean
        get translationKey(): string
        get fillSound(): Internal.SoundEvent
        get temperature(): number
        get emptySound(): Internal.SoundEvent
        get viscosity(): number
    }
    type FluidAttributes_ = FluidAttributes;
    abstract class AbstractCandleBlock extends Internal.Block {
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        static isLit($$0: Internal.BlockState_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        static extinguish($$0: Internal.Player_, $$1: Internal.BlockState_, $$2: Internal.LevelAccessor_, $$3: BlockPos_): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly LIGHT_PER_CANDLE: 3;
        static readonly LIT: Internal.BooleanProperty;
    }
    type AbstractCandleBlock_ = AbstractCandleBlock;
    class RealmsWorldOptions extends Internal.ValueObject {
        constructor($$0: boolean, $$1: boolean, $$2: boolean, $$3: boolean, $$4: number, $$5: boolean, $$6: number, $$7: number, $$8: boolean, $$9: string)
        clone(): any;
        getSlotName($$0: number): string;
        static createDefaults(): Internal.RealmsWorldOptions;
        clone(): this;
        getDefaultSlotName($$0: number): string;
        setEmpty($$0: boolean): void;
        static createEmptyDefaults(): Internal.RealmsWorldOptions;
        static parse($$0: Internal.JsonObject_): Internal.RealmsWorldOptions;
        toJson(): string;
        set empty($$0: boolean)
        readonly difficulty: number;
        readonly commandBlocks: boolean;
        empty: boolean;
        templateImage: string;
        readonly gameMode: number;
        readonly spawnMonsters: boolean;
        readonly forceGameMode: boolean;
        templateId: number;
        readonly spawnAnimals: boolean;
        readonly spawnNPCs: boolean;
        readonly spawnProtection: number;
        readonly pvp: boolean;
    }
    type RealmsWorldOptions_ = RealmsWorldOptions;
    class ItemGenBlock extends Internal.AEBaseEntityBlock<any> {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type ItemGenBlock_ = ItemGenBlock;
    class SizedIngredient implements Internal.Predicate<Internal.ItemStack> {
        static fromItems(amountNeeded: number, ...items: Internal.ItemLike_[]): Internal.SizedIngredient;
        static not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        write(buffer: Internal.FriendlyByteBuf_): void;
        static deserialize(json: Internal.JsonObject_): Internal.SizedIngredient;
        serialize(): Internal.JsonObject;
        static read(buffer: Internal.FriendlyByteBuf_): Internal.SizedIngredient;
        getAmountNeeded(): number;
        static isEqual<T>(arg0: any): Internal.Predicate<T>;
        static fromTag(tag: Internal.TagKey_<Internal.Item>, amountNeeded: number): Internal.SizedIngredient;
        test(arg0: any): boolean;
        static fromItems(...items: Internal.ItemLike_[]): Internal.SizedIngredient;
        static of(ingredient: Internal.Ingredient_): Internal.SizedIngredient;
        static fromTag(tag: Internal.TagKey_<Internal.Item>): Internal.SizedIngredient;
        or(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
        test(stack: Internal.ItemStack_): boolean;
        hasNoMatchingStacks(): boolean;
        getIngredient(): Internal.Ingredient;
        getMatchingStacks(): Internal.List<Internal.ItemStack>;
        negate(): Internal.Predicate<Internal.ItemStack>;
        static of(ingredient: Internal.Ingredient_, amountNeeded: number): Internal.SizedIngredient;
        and(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
        get amountNeeded(): number
        get ingredient(): Internal.Ingredient
        get matchingStacks(): Internal.List<Internal.ItemStack>
        static readonly EMPTY: Internal.SizedIngredient;
    }
    type SizedIngredient_ = SizedIngredient;
    class FabricEntityTypeBuilder$Mob <T extends Internal.Mob> extends Internal.FabricEntityTypeBuilder$Living<T> {
        disableSummon(): Internal.FabricEntityTypeBuilder<any>;
        /**
         * @deprecated
        */
        trackable(arg0: number, arg1: number, arg2: boolean): Internal.FabricEntityTypeBuilder$Living<any>;
        disableSaving(): Internal.FabricEntityTypeBuilder$Living<any>;
        dimensions(dimensions: Internal.EntityDimensions_): this;
        forceTrackedVelocityUpdates(forceTrackedVelocityUpdates: boolean): this;
        spawnRestriction(location: Internal.SpawnPlacements$Type_, heightmap: Internal.Heightmap$Types_, spawnPredicate: Internal.SpawnPlacements$SpawnPredicate_<T>): this;
        trackRangeChunks(range: number): this;
        fireImmune(): Internal.FabricEntityTypeBuilder<any>;
        /**
         * @deprecated
        */
        trackable(trackRangeBlocks: number, trackedUpdateRate: number): this;
        spawnGroup(arg0: Internal.MobCategory_): Internal.FabricEntityTypeBuilder$Living<any>;
        specificSpawnBlocks(arg0: Internal.Block_[]): Internal.FabricEntityTypeBuilder<any>;
        trackRangeBlocks(arg0: number): Internal.FabricEntityTypeBuilder<any>;
        spawnableFarFromPlayer(): Internal.FabricEntityTypeBuilder$Living<any>;
        build(): Internal.EntityType<T>;
        defaultAttributes(arg0: Internal.Supplier_<any>): Internal.FabricEntityTypeBuilder$Living<any>;
        trackedUpdateRate(arg0: number): Internal.FabricEntityTypeBuilder$Living<any>;
        entityFactory(arg0: Internal.EntityType$EntityFactory_<any>): Internal.FabricEntityTypeBuilder<any>;
    }
    type FabricEntityTypeBuilder$Mob_<T extends Internal.Mob> = FabricEntityTypeBuilder$Mob<T>;
    class FancyItemFrameItem extends Internal.Item {
        constructor(props: Internal.Item$Properties_, entityProvider: any_<Internal.HangingEntity, Internal.Level, BlockPos, Internal.Direction>)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type FancyItemFrameItem_ = FancyItemFrameItem;
    class BlockPlacerItem extends Internal.BlockItem {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        static get(): Internal.BlockPlacerItem;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        mimicUseOn(pContext: Internal.UseOnContext_, toPlace: Internal.Block_, foodProperties: Internal.FoodProperties_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        mimicGetPlacementState(pContext: Internal.BlockPlaceContext_, toPlace: Internal.Block_): Internal.BlockState;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        method_7709(pContext: Internal.BlockPlaceContext_, pState: Internal.BlockState_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        mimicPlace(pContext: Internal.BlockPlaceContext_, toPlace: Internal.Block_, overrideSound: SoundType_): Internal.InteractionResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BlockPlacerItem_ = BlockPlacerItem;
    class BendingTrunkPlacer extends Internal.TrunkPlacer {
        constructor($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.IntProvider_)
        static readonly CODEC: Internal.Codec<Internal.BendingTrunkPlacer>;
    }
    type BendingTrunkPlacer_ = BendingTrunkPlacer;
    class User {
        constructor($$0: string, $$1: string, $$2: string, $$3: Internal.Optional_<string>, $$4: Internal.Optional_<string>, $$5: Internal.User$Type_)
        getGameProfile(): Internal.GameProfile;
        getClientId(): Internal.Optional<string>;
        getSessionId(): string;
        getName(): string;
        getXuid(): Internal.Optional<string>;
        getUuid(): string;
        getAccessToken(): string;
        getType(): Internal.User$Type;
        getProfileId(): Internal.UUID;
        get gameProfile(): Internal.GameProfile
        get clientId(): Internal.Optional<string>
        get sessionId(): string
        get name(): string
        get xuid(): Internal.Optional<string>
        get uuid(): string
        get accessToken(): string
        get type(): Internal.User$Type
        get profileId(): Internal.UUID
    }
    type User_ = User;
    class UnboundedMapCodec <K, V> implements Internal.BaseMapCodec<K, V>, Internal.Codec<Internal.Map<K, V>> {
        constructor(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>)
        keyCodec(): Internal.Codec<K>;
        orElseGet(arg0: Internal.Consumer_<string>, arg1: Internal.Supplier_<Internal.Map<K, V>>): Internal.Codec<Internal.Map<K, V>>;
        dispatchStable<E>(arg0: Internal.Function_<E, Internal.Map<K, V>>, arg1: Internal.Function_<Internal.Map<K, V>, Internal.Codec<E>>): Internal.Codec<E>;
        optionalFieldOf(arg0: string, arg1: Internal.Map_<K, V>): Internal.MapCodec<Internal.Map<K, V>>;
        static empty<A>(): Internal.MapEncoder<A>;
        static error<A>(arg0: string): Internal.Encoder<A>;
        static unit<A>(arg0: Internal.Supplier_<A>): Internal.Codec<A>;
        deprecated(arg0: number): Internal.Codec<Internal.Map<K, V>>;
        optionalFieldOf(arg0: string, arg1: Internal.Map_<K, V>, arg2: Internal.Lifecycle_): Internal.MapCodec<Internal.Map<K, V>>;
        static floatRange(arg0: number, arg1: number): Internal.Codec<number>;
        dispatchMap<E>(arg0: Internal.Function_<E, Internal.Map<K, V>>, arg1: Internal.Function_<Internal.Map<K, V>, Internal.Codec<E>>): Internal.MapCodec<E>;
        encode<T>(arg0: Internal.Map_<K, V>, arg1: Internal.DynamicOps_<T>, arg2: Internal.RecordBuilder_<T>): Internal.RecordBuilder<T>;
        partialDispatch<E>(arg0: string, arg1: Internal.Function_<E, Internal.DataResult<Internal.Map<K, V>>>, arg2: Internal.Function_<Internal.Map<K, V>, Internal.DataResult<Internal.Codec<E>>>): Internal.Codec<E>;
        static ofBoxed<A>(arg0: Internal.Decoder$Boxed_<A>): Internal.Decoder<A>;
        dispatch<E>(arg0: string, arg1: Internal.Function_<E, Internal.Map<K, V>>, arg2: Internal.Function_<Internal.Map<K, V>, Internal.Codec<E>>): Internal.Codec<E>;
        parse<T>(arg0: Internal.DynamicOps_<T>, arg1: T): Internal.DataResult<Internal.Map<K, V>>;
        map<B>(arg0: Internal.Function_<Internal.Map<K, V>, B>): Internal.Decoder<B>;
        static unit<A>(arg0: A): Internal.Codec<A>;
        static intRange(arg0: number, arg1: number): Internal.Codec<number>;
        dispatchMap<E>(arg0: string, arg1: Internal.Function_<E, Internal.Map<K, V>>, arg2: Internal.Function_<Internal.Map<K, V>, Internal.Codec<E>>): Internal.MapCodec<E>;
        flatComap<B>(arg0: Internal.Function_<B, Internal.DataResult<Internal.Map<K, V>>>): Internal.Encoder<B>;
        decode<T>(arg0: Internal.Dynamic_<T>): Internal.DataResult<com.mojang.datafixers.util.Pair<Internal.Map<K, V>, T>>;
        static pair<F, S>(arg0: Internal.Codec_<F>, arg1: Internal.Codec_<S>): Internal.Codec<com.mojang.datafixers.util.Pair<F, S>>;
        elementCodec(): Internal.Codec<V>;
        static either<F, S>(arg0: Internal.Codec_<F>, arg1: Internal.Codec_<S>): Internal.Codec<Internal.Either<F, S>>;
        static checkRange<N extends number & Internal.Comparable<N>>(arg0: N, arg1: N): Internal.Function<N, Internal.DataResult<N>>;
        boxed(): Internal.Decoder$Boxed<Internal.Map<K, V>>;
        static unboundedMap<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>): Internal.UnboundedMapCodec<K, V>;
        fieldOf(arg0: string): Internal.MapDecoder<any>;
        optionalFieldOf(arg0: string): Internal.MapCodec<Internal.Optional<Internal.Map<K, V>>>;
        static of<A>(arg0: Internal.Encoder_<A>, arg1: Internal.Decoder_<A>, arg2: string): Internal.Codec<A>;
        encode<T>(arg0: Internal.Map_<K, V>, arg1: Internal.DynamicOps_<T>, arg2: T): Internal.DataResult<T>;
        orElse(arg0: Internal.Map_<K, V>): Internal.Codec<Internal.Map<K, V>>;
        static ofSimple<A>(arg0: Internal.Decoder$Simple_<A>): Internal.Decoder<A>;
        static mapEither<F, S>(arg0: Internal.MapCodec_<F>, arg1: Internal.MapCodec_<S>): Internal.MapCodec<Internal.Either<F, S>>;
        static doubleRange(arg0: number, arg1: number): Internal.Codec<number>;
        promotePartial(arg0: Internal.Consumer_<string>): Internal.Codec<Internal.Map<K, V>>;
        static optionalField<F>(arg0: string, arg1: Internal.Codec_<F>): Internal.MapCodec<Internal.Optional<F>>;
        xmap<S>(arg0: Internal.Function_<Internal.Map<K, V>, S>, arg1: Internal.Function_<S, Internal.Map<K, V>>): Internal.Codec<S>;
        listOf(): Internal.Codec<Internal.List<Internal.Map<K, V>>>;
        static simpleMap<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>, arg2: Internal.Keyable_): Internal.SimpleMapCodec<K, V>;
        parse<T>(arg0: Internal.Dynamic_<T>): Internal.DataResult<Internal.Map<K, V>>;
        orElseGet(arg0: Internal.UnaryOperator_<string>, arg1: Internal.Supplier_<Internal.Map<K, V>>): Internal.Codec<Internal.Map<K, V>>;
        stable(): Internal.Codec<Internal.Map<K, V>>;
        flatComapMap<S>(arg0: Internal.Function_<Internal.Map<K, V>, S>, arg1: Internal.Function_<S, Internal.DataResult<Internal.Map<K, V>>>): Internal.Codec<S>;
        static ofTerminal<A>(arg0: Internal.Decoder$Terminal_<A>): Internal.Decoder<A>;
        simple(): Internal.Decoder$Simple<Internal.Map<K, V>>;
        encode(arg0: any, arg1: Internal.DynamicOps_<any>, arg2: any): Internal.DataResult<any>;
        decode<T>(arg0: Internal.DynamicOps_<T>, arg1: Internal.MapLike_<T>): Internal.DataResult<Internal.Map<K, V>>;
        decode<T>(arg0: Internal.DynamicOps_<T>, arg1: T): Internal.DataResult<com.mojang.datafixers.util.Pair<Internal.Map<K, V>, T>>;
        static list<E>(arg0: Internal.Codec_<E>): Internal.Codec<Internal.List<E>>;
        orElse(arg0: Internal.Consumer_<string>, arg1: Internal.Map_<K, V>): Internal.Codec<Internal.Map<K, V>>;
        comapFlatMap<S>(arg0: Internal.Function_<Internal.Map<K, V>, Internal.DataResult<S>>, arg1: Internal.Function_<S, Internal.Map<K, V>>): Internal.Codec<S>;
        comap<B>(arg0: Internal.Function_<B, Internal.Map<K, V>>): Internal.Encoder<B>;
        flatMap<B>(arg0: Internal.Function_<Internal.Map<K, V>, Internal.DataResult<B>>): Internal.Decoder<B>;
        static of<A>(arg0: Internal.MapEncoder_<A>, arg1: Internal.MapDecoder_<A>): Internal.MapCodec<A>;
        mapResult(arg0: Internal.Codec$ResultFunction_<Internal.Map<K, V>>): Internal.Codec<Internal.Map<K, V>>;
        dispatch<E>(arg0: Internal.Function_<E, Internal.Map<K, V>>, arg1: Internal.Function_<Internal.Map<K, V>, Internal.Codec<E>>): Internal.Codec<E>;
        encodeStart<T>(arg0: Internal.DynamicOps_<T>, arg1: Internal.Map_<K, V>): Internal.DataResult<T>;
        terminal(): Internal.Decoder$Terminal<Internal.Map<K, V>>;
        optionalFieldOf(arg0: string, arg1: Internal.Lifecycle_, arg2: Internal.Map_<K, V>, arg3: Internal.Lifecycle_): Internal.MapCodec<Internal.Map<K, V>>;
        static of<A>(arg0: Internal.Encoder_<A>, arg1: Internal.Decoder_<A>): Internal.Codec<A>;
        static of<A>(arg0: Internal.MapEncoder_<A>, arg1: Internal.MapDecoder_<A>, arg2: Internal.Supplier_<string>): Internal.MapCodec<A>;
        withLifecycle(arg0: Internal.Lifecycle_): Internal.Codec<Internal.Map<K, V>>;
        static compoundList<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>): Internal.Codec<Internal.List<com.mojang.datafixers.util.Pair<K, V>>>;
        orElseGet(arg0: Internal.Supplier_<Internal.Map<K, V>>): Internal.Codec<Internal.Map<K, V>>;
        orElse(arg0: Internal.UnaryOperator_<string>, arg1: Internal.Map_<K, V>): Internal.Codec<Internal.Map<K, V>>;
        flatXmap<S>(arg0: Internal.Function_<Internal.Map<K, V>, Internal.DataResult<S>>, arg1: Internal.Function_<S, Internal.DataResult<Internal.Map<K, V>>>): Internal.Codec<S>;
        static mapPair<F, S>(arg0: Internal.MapCodec_<F>, arg1: Internal.MapCodec_<S>): Internal.MapCodec<com.mojang.datafixers.util.Pair<F, S>>;
    }
    type UnboundedMapCodec_<K, V> = UnboundedMapCodec<K, V>;
    abstract class AbstractFunnelBlock extends Internal.Block implements Internal.ProperWaterloggedBlock, Internal.IBE<Internal.FunnelBlockEntity>, com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.ReducedDestroyEffects {
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.FunnelBlockEntity>): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static isFunnel(state: Internal.BlockState_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        handleBox(x1: number, y1: number, z1: number, x2: number, y2: number, z2: number, chance: number, state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): void;
        static getFunnelFacing(state: Internal.BlockState_): Internal.Direction;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.FunnelBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        static tryInsert(worldIn: Internal.Level_, pos: BlockPos_, toInsert: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.FunnelBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntityType(): Internal.BlockEntityType<Internal.FunnelBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getBlockEntityClass(): typeof Internal.FunnelBlockEntity;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        emi(amount: number): Internal.EmiStack;
        addDestroyEffects(state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.FunnelBlockEntity>;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityType(): Internal.BlockEntityType<Internal.FunnelBlockEntity>
        get mod(): string
        get blockEntityClass(): typeof Internal.FunnelBlockEntity
        static readonly POWERED: Internal.BooleanProperty;
    }
    type AbstractFunnelBlock_ = AbstractFunnelBlock;
    class ModifierSortingRecipe extends Internal.AbstractWorktableRecipe {
        constructor(id: ResourceLocation_, inputs: Internal.List_<Internal.SizedIngredient>)
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getGroup(): string;
        updateInputs(result: Internal.IToolStackView_, inv: Internal.ITinkerableContainer$Mutable_, selected: Internal.ModifierEntry_, isServer: boolean): void;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        toolResultSize(inv: Internal.ITinkerableContainer_, selected: Internal.ModifierEntry_): number;
        getSchema(): Internal.RecipeSchema;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        /**
         * @deprecated
        */
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        isModifierOutput(): boolean;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        getRemainingItems($$0: Internal.ITinkerableContainer_): Internal.NonNullList<Internal.ItemStack>;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        /**
         * @deprecated
        */
        assemble(inv: Internal.ITinkerableContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getMod(): string;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get modifierOutput(): boolean
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type ModifierSortingRecipe_ = ModifierSortingRecipe;
    class RawAnimation {
        constructor(animationList: Internal.List_<Internal.RawAnimation$Stage>)
        static begin(): Internal.RawAnimation;
        then(animationName: string, loopType: Internal.Animation$LoopType_): this;
        thenLoop(animationName: string): this;
        getStageCount(): number;
        static copyOf(other: Internal.RawAnimation_): Internal.RawAnimation;
        thenWait(ticks: number): this;
        thenPlayAndHold(animation: string): this;
        thenPlayXTimes(animationName: string, playCount: number): this;
        thenPlay(animationName: string): this;
        getAnimationStages(): Internal.List<Internal.RawAnimation$Stage>;
        get stageCount(): number
        get animationStages(): Internal.List<Internal.RawAnimation$Stage>
    }
    type RawAnimation_ = RawAnimation;
    class SimpleRandomFeatureConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: Internal.HolderSet_<Internal.PlacedFeature>)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.SimpleRandomFeatureConfiguration>;
        readonly features: Internal.HolderSet<Internal.PlacedFeature>;
    }
    type SimpleRandomFeatureConfiguration_ = SimpleRandomFeatureConfiguration;
    class ExtendoGripItem extends Internal.Item implements Internal.ItemExtras {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        hasSecondaryUse(stack: Internal.ItemStack_, level: Internal.LevelReader_, pos: BlockPos_, player: Internal.Player_): Internal.TriState;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static consumeDurabilityOnBlockBreak(level: Internal.Level_, player: Internal.Player_, blockPos: BlockPos_, blockState: Internal.BlockState_, blockEntity: Internal.BlockEntity_): void;
        static holdingExtendoGripIncreasesRange(entity: Internal.LivingEntity_): void;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        static consumeDurabilityOnPlace(blockPlaceContext: Internal.BlockPlaceContext_, blockPos: BlockPos_, blockState: Internal.BlockState_): void;
        setAttackSpeed(attackSpeed: number): void;
        static attacksByExtendoGripHaveMoreKnockback(strength: number, player2: Internal.Player_): number;
        static bufferLivingAttackEvent(damageSource: DamageSource_, attacked: Internal.LivingEntity_, amount: number): number;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        static isHoldingExtendoGrip(player: Internal.Player_): boolean;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        static addReachToJoiningPlayersHoldingExtendo(entity: Internal.Entity_, persistentData: Internal.CompoundTag_): void;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly MAX_DAMAGE: 200;
        static readonly singleRangeAttributeModifier: Internal.AttributeModifier;
        static readonly DUAL_EXTENDO_MARKER: "createDualExtendo";
        static readonly doubleRangeAttributeModifier: Internal.AttributeModifier;
        static readonly EXTENDO_MARKER: "createExtendo";
    }
    type ExtendoGripItem_ = ExtendoGripItem;
    abstract class CharBuffer extends Internal.Buffer implements Internal.Comparable<Internal.CharBuffer>, Internal.CharSequence, Internal.Appendable, Internal.Readable {
        mark(): this;
        static wrap(arg0: string[], arg1: number, arg2: number): Internal.CharBuffer;
        abstract get(): string;
        static wrap(arg0: Internal.CharSequence_): Internal.CharBuffer;
        put(arg0: string): this;
        position(arg0: number): this;
        isEmpty(): boolean;
        clear(): this;
        flip(): this;
        compareTo(arg0: any): number;
        subSequence(arg0: number, arg1: number): Internal.CharSequence;
        read(arg0: Internal.CharBuffer_): number;
        abstract asReadOnlyBuffer(): this;
        get(arg0: number, arg1: string[], arg2: number, arg3: number): this;
        abstract order(): Internal.ByteOrder;
        reset(): this;
        put(arg0: number, arg1: string[]): this;
        charAt(arg0: number): string;
        abstract put(arg0: number, arg1: string): this;
        get(arg0: number, arg1: string[]): this;
        put(arg0: Internal.CharBuffer_): this;
        length(): number;
        put(arg0: number, arg1: string[], arg2: number, arg3: number): this;
        abstract compact(): this;
        put(arg0: number, arg1: Internal.CharBuffer_, arg2: number, arg3: number): this;
        abstract get(arg0: number): string;
        get(arg0: string[]): this;
        static allocate(arg0: number): Internal.CharBuffer;
        abstract put(arg0: string): this;
        put(arg0: string[]): this;
        put(arg0: string, arg1: number, arg2: number): this;
        append(arg0: string): this;
        static wrap(arg0: Internal.CharSequence_, arg1: number, arg2: number): Internal.CharBuffer;
        append(arg0: Internal.CharSequence_): this;
        abstract slice(): this;
        static wrap(arg0: string[]): Internal.CharBuffer;
        static compare(arg0: Internal.CharSequence_, arg1: Internal.CharSequence_): number;
        append(arg0: Internal.CharSequence_, arg1: number, arg2: number): this;
        mismatch(arg0: Internal.CharBuffer_): number;
        compareTo(arg0: Internal.CharBuffer_): number;
        chars(): Internal.IntStream;
        get(arg0: string[], arg1: number, arg2: number): this;
        put(arg0: string[], arg1: number, arg2: number): this;
        abstract slice(arg0: number, arg1: number): this;
        abstract duplicate(): this;
        codePoints(): Internal.IntStream;
        get empty(): boolean
    }
    type CharBuffer_ = CharBuffer;
    class ImageIcon extends Internal.Icon implements Internal.IResourceIcon {
        constructor(tex: ResourceLocation_)
        draw3D(graphics: Internal.GuiGraphics_): void;
        withTint(c: Internal.Color4I_): this;
        drawStatic(graphics: Internal.GuiGraphics_, x: number, y: number, w: number, h: number): void;
        bindTexture(): void;
        getResourceLocation(): ResourceLocation;
        get resourceLocation(): ResourceLocation
        tileSize: number;
        maxV: number;
        color: Internal.Color4I;
        maxU: number;
        static readonly MISSING_IMAGE: ResourceLocation;
        minU: number;
        readonly texture: ResourceLocation;
        minV: number;
    }
    type ImageIcon_ = ImageIcon;
    class ItemDragonHorn extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static getDragonType(stack: Internal.ItemStack_): number;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemDragonHorn_ = ItemDragonHorn;
    class LampPost extends Internal.LampBase implements Internal.SimpleWaterloggedBlock {
        constructor()
        canPlaceLiquid(pLevel: Internal.BlockGetter_, pPos: BlockPos_, pState: Internal.BlockState_, pFluid: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly POSITION: Internal.EnumProperty<Internal.LampPost$Position>;
    }
    type LampPost_ = LampPost;
    interface ComponentProvider extends Internal.ComponentAccess {
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): this;
        getRecipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>;
        toComponentPacket<C extends Internal.AutoSyncedComponent>(key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        abstract getComponentContainer(): Internal.ComponentContainer;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        get recipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>
        get componentContainer(): Internal.ComponentContainer
        (): Internal.ComponentContainer_;
    }
    type ComponentProvider_ = ComponentProvider;
    class DataIngredient extends Internal.Ingredient {
        getDisplayStacks(): Internal.ItemStackSet;
        static ingredient(parent: Internal.Ingredient_, required: Internal.TagKey_<Internal.Item>): Internal.DataIngredient;
        static tag(tag: Internal.TagKey_<Internal.Item>): Internal.DataIngredient;
        getCritereon(prov: Internal.RegistrateRecipeProvider_): Internal.InventoryChangeTrigger$TriggerInstance;
        getItemIds(): Internal.Set<string>;
        static ingredient(parent: Internal.Ingredient_, required: Internal.ItemLike_): Internal.DataIngredient;
        asStack(): InputItem;
        toJson(): Internal.JsonElement;
        or(ingredient: Internal.Ingredient_): Internal.Ingredient;
        static isEqual<T>(arg0: any): Internal.Predicate<T>;
        isWildcard(): boolean;
        getId(): ResourceLocation;
        getItemTypes(): Internal.Set<Internal.Item>;
        and(ingredient: Internal.Ingredient_): Internal.Ingredient;
        static ingredient(parent: Internal.Ingredient_, id: ResourceLocation_, ...criteria: any_[]): Internal.DataIngredient;
        negate(): Internal.Predicate<Internal.ItemStack>;
        subtract(subtracted: Internal.Ingredient_): Internal.Ingredient;
        testItem(item: Internal.Item_): boolean;
        static not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        static items<T extends Internal.ItemLike>(first: T, ...others: T[]): Internal.DataIngredient;
        static items<T extends Internal.ItemLike>(first: Internal.NonNullSupplier_<T>, ...others: Internal.NonNullSupplier_<T>[]): Internal.DataIngredient;
        withCount(count: number): InputItem;
        static stacks(first: Internal.ItemStack_, ...others: Internal.ItemStack_[]): Internal.DataIngredient;
        getStacks(): Internal.ItemStackSet;
        or(other: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
        getFirst(): Internal.ItemStack;
        asIngredient(): Internal.Ingredient;
        and(other: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
        get displayStacks(): Internal.ItemStackSet
        get itemIds(): Internal.Set<string>
        get wildcard(): boolean
        get id(): ResourceLocation
        get itemTypes(): Internal.Set<Internal.Item>
        get stacks(): Internal.ItemStackSet
        get first(): Internal.ItemStack
    }
    type DataIngredient_ = DataIngredient;
    class ComponentEvent extends Internal.AWTEvent {
        constructor(arg0: Internal.Component_, arg1: number)
        getComponent(): Internal.Component;
        get component(): Internal.Component
        static readonly COMPONENT_FIRST: 100;
        static readonly COMPONENT_SHOWN: 102;
        static readonly COMPONENT_HIDDEN: 103;
        static readonly COMPONENT_LAST: 103;
        static readonly COMPONENT_MOVED: 100;
        static readonly COMPONENT_RESIZED: 101;
    }
    type ComponentEvent_ = ComponentEvent;
    class Uniform extends Internal.AbstractUniform implements Internal.AutoCloseable {
        constructor($$0: string, $$1: number, $$2: number, $$3: Internal.Shader_)
        upload(): void;
        getCount(): number;
        getFloatBuffer(): Internal.FloatBuffer;
        static glGetAttribLocation($$0: number, $$1: Internal.CharSequence_): number;
        setLocation($$0: number): void;
        static uploadInteger($$0: number, $$1: number): void;
        set($$0: number, $$1: number): void;
        getIntBuffer(): Internal.IntBuffer;
        static glBindAttribLocation($$0: number, $$1: number, $$2: Internal.CharSequence_): void;
        getType(): number;
        close(): void;
        static glGetUniformLocation($$0: number, $$1: Internal.CharSequence_): number;
        getName(): string;
        static getTypeFromString($$0: string): number;
        getLocation(): number;
        get count(): number
        get floatBuffer(): Internal.FloatBuffer
        set location($$0: number)
        get intBuffer(): Internal.IntBuffer
        get type(): number
        get name(): string
        get location(): number
        static readonly UT_MAT4: 10;
        static readonly UT_FLOAT4: 7;
        static readonly UT_MAT2: 8;
        static readonly UT_MAT3: 9;
        static readonly UT_INT2: 1;
        static readonly UT_INT1: 0;
        static readonly UT_INT4: 3;
        static readonly UT_FLOAT3: 6;
        static readonly UT_INT3: 2;
        static readonly UT_FLOAT2: 5;
        static readonly UT_FLOAT1: 4;
    }
    type Uniform_ = Uniform;
    interface NonNullTriFunction <T, U, P, R> extends Internal.TriFunction<T, U, P, R> {
        andThen<V>(after: Internal.Function_<R, V>): Internal.TriFunction<T, U, P, V>;
        abstract apply(arg0: T, arg1: U, arg2: P): R;
        (arg0: T, arg1: U, arg2: P): R;
    }
    type NonNullTriFunction_<T, U, P, R> = NonNullTriFunction<T, U, P, R>;
    class EnchantmentInstance extends Internal.WeightedEntry$IntrusiveBase {
        constructor($$0: Internal.Enchantment_, $$1: number)
        static wrap<T>($$0: T, $$1: number): Internal.WeightedEntry$Wrapper<T>;
        readonly level: number;
        readonly enchantment: Internal.Enchantment;
    }
    type EnchantmentInstance_ = EnchantmentInstance;
    class ClientboundRecipePacket$State extends Internal.Enum<Internal.ClientboundRecipePacket$State> {
        static values(): Internal.ClientboundRecipePacket$State[];
        static valueOf($$0: string): Internal.ClientboundRecipePacket$State;
        static readonly REMOVE: Internal.ClientboundRecipePacket$State;
        static readonly ADD: Internal.ClientboundRecipePacket$State;
        static readonly INIT: Internal.ClientboundRecipePacket$State;
    }
    type ClientboundRecipePacket$State_ = "init" | "remove" | ClientboundRecipePacket$State | "add";
    abstract class ConfigWithVariants <T> extends Internal.ConfigValue<T> {
        constructor()
        abstract getIteration(arg0: T, arg1: boolean): T;
    }
    type ConfigWithVariants_<T> = ConfigWithVariants<T>;
    class ComplexFloatMatrix {
        constructor()
        constructor(arg0: number, arg1: number)
        constructor(arg0: Internal.FloatMatrix_, arg1: Internal.FloatMatrix_)
        constructor(arg0: number[][])
        constructor(arg0: number[])
        constructor(arg0: Internal.FloatMatrix_)
        constructor(arg0: number, arg1: number, ...arg2: number[])
        constructor(arg0: Internal.ComplexFloat_[])
        constructor(arg0: number)
        constructor(arg0: string)
        static zeros(arg0: number, arg1: number): Internal.ComplexFloatMatrix;
        rsubi(arg0: number, arg1: Internal.ComplexFloatMatrix_): this;
        mmuli(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_): this;
        subi(arg0: Internal.ComplexFloat_): this;
        out(arg0: Internal.DataOutputStream_): void;
        addColumnVector(arg0: Internal.ComplexFloatMatrix_): void;
        muli(arg0: Internal.ComplexFloat_, arg1: Internal.ComplexFloatMatrix_): this;
        putReal(arg0: number[], arg1: number[], arg2: number): this;
        conj(): this;
        mmuli(arg0: Internal.ComplexFloatMatrix_): this;
        divi(arg0: Internal.ComplexFloat_, arg1: Internal.ComplexFloatMatrix_): this;
        mmuli(arg0: number): this;
        or(arg0: Internal.ComplexFloat_): this;
        rdiv(arg0: Internal.ComplexFloat_): this;
        rdivi(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_): this;
        not(): this;
        diag(): this;
        rdivi(arg0: Internal.ComplexFloatMatrix_): this;
        get(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_): this;
        divi(arg0: number, arg1: Internal.ComplexFloatMatrix_): this;
        columnMeans(): this;
        isVector(): boolean;
        putReal(arg0: number, arg1: number): this;
        get(arg0: Internal.ComplexFloatMatrix_): this;
        assertMultipliesWith(arg0: Internal.ComplexFloatMatrix_): void;
        ne(arg0: Internal.ComplexFloatMatrix_): this;
        xori(arg0: Internal.ComplexFloat_): this;
        put(arg0: number, arg1: number[], arg2: Internal.ComplexFloat_): this;
        getLength(): number;
        add(arg0: Internal.ComplexFloat_): this;
        sub(arg0: number): this;
        putReal(arg0: Internal.ComplexFloatMatrix_, arg1: number, arg2: number): this;
        sameLength(arg0: Internal.ComplexFloatMatrix_): boolean;
        rsub(arg0: Internal.ComplexFloatMatrix_): this;
        swapColumns(arg0: number, arg1: number): this;
        putReal(arg0: number, arg1: number, arg2: number): this;
        assertSameSize(arg0: Internal.ComplexFloatMatrix_): void;
        muli(arg0: number, arg1: Internal.ComplexFloatMatrix_): this;
        put(arg0: number, arg1: number, arg2: Internal.ComplexFloat_): this;
        put(arg0: number, arg1: number, arg2: number): this;
        muli(arg0: Internal.ComplexFloat_): this;
        assertSameLength(arg0: Internal.ComplexFloatMatrix_): void;
        put(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_, arg2: Internal.ComplexFloat_): this;
        put(arg0: number[], arg1: number, arg2: number): this;
        divi(arg0: Internal.ComplexFloat_): this;
        static diag(arg0: Internal.ComplexFloatMatrix_): Internal.ComplexFloatMatrix;
        put(arg0: number[], arg1: number, arg2: Internal.ComplexFloatMatrix_): this;
        get(arg0: number, arg1: Internal.ComplexFloatMatrix_): this;
        rankOneUpdate(arg0: Internal.ComplexFloat_, arg1: Internal.ComplexFloatMatrix_): this;
        put(arg0: number[], arg1: Internal.ComplexFloat_): this;
        isSquare(): boolean;
        rdivi(arg0: number): this;
        putImag(arg0: Internal.ComplexFloatMatrix_, arg1: number, arg2: number): this;
        rsub(arg0: number): this;
        rankOneUpdate(arg0: number, arg1: Internal.ComplexFloatMatrix_): this;
        put(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloat_): this;
        ne(arg0: number): this;
        putImag(arg0: number[], arg1: number, arg2: number): this;
        ori(arg0: Internal.ComplexFloat_): this;
        rsubi(arg0: Internal.ComplexFloat_, arg1: Internal.ComplexFloatMatrix_): this;
        getReal(arg0: number): number;
        putColumn(arg0: number, arg1: Internal.ComplexFloatMatrix_): void;
        andi(arg0: Internal.ComplexFloat_): this;
        getRow(arg0: number): this;
        sameSize(arg0: Internal.ComplexFloatMatrix_): boolean;
        noti(): this;
        nei(arg0: Internal.ComplexFloat_, arg1: Internal.ComplexFloatMatrix_): this;
        rowMeans(): this;
        putImag(arg0: number[], arg1: number[], arg2: number): this;
        rdivi(arg0: Internal.ComplexFloat_, arg1: Internal.ComplexFloatMatrix_): this;
        mmuli(arg0: number, arg1: Internal.ComplexFloatMatrix_): this;
        eq(arg0: Internal.ComplexFloat_): this;
        static diag(arg0: Internal.ComplexFloatMatrix_, arg1: number, arg2: number): Internal.ComplexFloatMatrix;
        put(arg0: number[], arg1: number[], arg2: Internal.ComplexFloat_): this;
        swapRows(arg0: number, arg1: number): this;
        putReal(arg0: number, arg1: number[], arg2: number): this;
        dup(): this;
        rsubi(arg0: Internal.ComplexFloatMatrix_): this;
        eq(arg0: number): this;
        muli(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_): this;
        toBooleanArray(): boolean[];
        neg(): this;
        eqi(arg0: number): this;
        div(arg0: Internal.ComplexFloat_): this;
        rowSums(): this;
        get(arg0: number): Internal.ComplexFloat;
        imag(): Internal.FloatMatrix;
        xori(arg0: number, arg1: Internal.ComplexFloatMatrix_): this;
        and(arg0: Internal.ComplexFloatMatrix_): this;
        divi(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_): this;
        static zeros(arg0: number): Internal.ComplexFloatMatrix;
        put(arg0: number, arg1: Internal.ComplexFloatMatrix_, arg2: Internal.ComplexFloatMatrix_): this;
        getImag(arg0: number): number;
        static concatVertically(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_): Internal.ComplexFloatMatrix;
        ne(arg0: Internal.ComplexFloat_): this;
        div(arg0: Internal.ComplexFloatMatrix_): this;
        assertSquare(): void;
        get(arg0: number, arg1: number[]): this;
        static scalar(arg0: number): Internal.ComplexFloatMatrix;
        xor(arg0: Internal.ComplexFloat_): this;
        static concatHorizontally(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_): Internal.ComplexFloatMatrix;
        isColumnVector(): boolean;
        isEmpty(): boolean;
        andi(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_): this;
        putReal(arg0: number[], arg1: number): this;
        putImag(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_, arg2: number): this;
        ori(arg0: Internal.ComplexFloatMatrix_): this;
        findIndices(): number[];
        ori(arg0: number): this;
        toBooleanArray2(): boolean[][];
        eqi(arg0: Internal.ComplexFloatMatrix_): this;
        put(arg0: number, arg1: Internal.ComplexFloatMatrix_, arg2: Internal.ComplexFloat_): this;
        subi(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_): this;
        rdivi(arg0: Internal.ComplexFloat_): this;
        andi(arg0: number, arg1: Internal.ComplexFloatMatrix_): this;
        indexRows(arg0: number): number;
        isRowVector(): boolean;
        subColumnVector(arg0: Internal.ComplexFloatMatrix_): void;
        print(): void;
        static ones(arg0: number, arg1: number): Internal.ComplexFloatMatrix;
        subi(arg0: number, arg1: Internal.ComplexFloatMatrix_): this;
        getRows(): number;
        and(arg0: number): this;
        putImag(arg0: Internal.ComplexFloatMatrix_, arg1: number): this;
        eqi(arg0: Internal.ComplexFloat_, arg1: Internal.ComplexFloatMatrix_): this;
        rsubi(arg0: Internal.ComplexFloat_): this;
        negi(): this;
        ori(arg0: Internal.ComplexFloat_, arg1: Internal.ComplexFloatMatrix_): this;
        put(arg0: number[], arg1: number, arg2: Internal.ComplexFloat_): this;
        eq(arg0: Internal.ComplexFloatMatrix_): this;
        putImag(arg0: number, arg1: number, arg2: number): this;
        real(): Internal.FloatMatrix;
        put(arg0: number[], arg1: number): this;
        add(arg0: number): this;
        add(arg0: Internal.ComplexFloatMatrix_): this;
        put(arg0: number[], arg1: Internal.ComplexFloatMatrix_): this;
        xori(arg0: number): this;
        nei(arg0: number): this;
        rsub(arg0: Internal.ComplexFloat_): this;
        put(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_, arg2: number): this;
        nei(arg0: Internal.ComplexFloatMatrix_): this;
        put(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_, arg2: Internal.ComplexFloatMatrix_): this;
        norm1(): number;
        get(arg0: number, arg1: Internal.ComplexFloat_): Internal.ComplexFloat;
        nei(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_): this;
        get(arg0: Internal.ComplexFloatMatrix_, arg1: number): this;
        copy(arg0: Internal.ComplexFloatMatrix_): this;
        xori(arg0: Internal.ComplexFloatMatrix_): this;
        xori(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_): this;
        putImag(arg0: number, arg1: number[], arg2: number): this;
        dotu(arg0: Internal.ComplexFloatMatrix_): Internal.ComplexFloat;
        get(arg0: number[], arg1: number): this;
        xor(arg0: number): this;
        or(arg0: number): this;
        put(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_): this;
        addi(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_): this;
        rdiv(arg0: number): this;
        resize(arg0: number, arg1: number): void;
        get(arg0: number, arg1: number): Internal.ComplexFloat;
        get(arg0: number, arg1: number, arg2: Internal.ComplexFloat_): Internal.ComplexFloat;
        transpose(): this;
        addi(arg0: Internal.ComplexFloatMatrix_): this;
        mmul(arg0: Internal.ComplexFloat_): this;
        save(arg0: string): void;
        div(arg0: number): this;
        rankOneUpdate(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_): this;
        addi(arg0: number, arg1: Internal.ComplexFloatMatrix_): this;
        put(arg0: number, arg1: number[], arg2: number): this;
        get(arg0: number[]): this;
        sub(arg0: Internal.ComplexFloat_): this;
        dotc(arg0: Internal.ComplexFloatMatrix_): Internal.ComplexFloat;
        static ones(arg0: number): Internal.ComplexFloatMatrix;
        mul(arg0: number): this;
        put(arg0: number, arg1: number): this;
        toDoubleArray(): number[];
        multipliesWith(arg0: Internal.ComplexFloatMatrix_): boolean;
        rankOneUpdate(arg0: Internal.ComplexFloat_, arg1: Internal.ComplexFloatMatrix_, arg2: Internal.ComplexFloatMatrix_): this;
        conji(): this;
        get(arg0: number[], arg1: number[]): this;
        columnSums(): this;
        getReal(): Internal.FloatMatrix;
        xor(arg0: Internal.ComplexFloatMatrix_): this;
        truthi(): this;
        putImag(arg0: number, arg1: Internal.ComplexFloatMatrix_, arg2: number): this;
        scalar(): Internal.ComplexFloat;
        or(arg0: Internal.ComplexFloatMatrix_): this;
        put(arg0: number, arg1: Internal.ComplexFloatMatrix_, arg2: number): this;
        eqi(arg0: Internal.ComplexFloat_): this;
        rankOneUpdate(arg0: Internal.ComplexFloatMatrix_): this;
        index(arg0: number, arg1: number): number;
        addi(arg0: number): this;
        nei(arg0: number, arg1: Internal.ComplexFloatMatrix_): this;
        rdiv(arg0: Internal.ComplexFloatMatrix_): this;
        put(arg0: Internal.ComplexFloatMatrix_, arg1: number, arg2: number): this;
        mmuli(arg0: Internal.ComplexFloat_, arg1: Internal.ComplexFloatMatrix_): this;
        putImag(arg0: number, arg1: number): this;
        indexColumns(arg0: number): number;
        and(arg0: Internal.ComplexFloat_): this;
        sum(): Internal.ComplexFloat;
        getColumn(arg0: number): this;
        isScalar(): boolean;
        ori(arg0: number, arg1: Internal.ComplexFloatMatrix_): this;
        rsubi(arg0: number): this;
        addi(arg0: Internal.ComplexFloat_, arg1: Internal.ComplexFloatMatrix_): this;
        addRowVector(arg0: Internal.ComplexFloatMatrix_): void;
        muli(arg0: Internal.ComplexFloatMatrix_): this;
        load(arg0: string): void;
        rsubi(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_): this;
        putReal(arg0: number, arg1: Internal.ComplexFloatMatrix_, arg2: number): this;
        normmax(): number;
        putReal(arg0: number[], arg1: number, arg2: number): this;
        mmul(arg0: Internal.ComplexFloatMatrix_): this;
        reshape(arg0: number, arg1: number): this;
        put(arg0: number[], arg1: number[], arg2: Internal.ComplexFloatMatrix_): this;
        rankOneUpdate(arg0: number, arg1: Internal.ComplexFloatMatrix_, arg2: Internal.ComplexFloatMatrix_): this;
        xori(arg0: Internal.ComplexFloat_, arg1: Internal.ComplexFloatMatrix_): this;
        mul(arg0: Internal.ComplexFloat_): this;
        divi(arg0: Internal.ComplexFloatMatrix_): this;
        rdivi(arg0: number, arg1: Internal.ComplexFloatMatrix_): this;
        put(arg0: Internal.ComplexFloatMatrix_, arg1: number, arg2: Internal.ComplexFloatMatrix_): this;
        putReal(arg0: Internal.ComplexFloatMatrix_, arg1: number): this;
        eqi(arg0: number, arg1: Internal.ComplexFloatMatrix_): this;
        putRow(arg0: number, arg1: Internal.ComplexFloatMatrix_): void;
        putReal(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_, arg2: number): this;
        subi(arg0: Internal.ComplexFloat_, arg1: Internal.ComplexFloatMatrix_): this;
        subRowVector(arg0: Internal.ComplexFloatMatrix_): void;
        truth(): this;
        ori(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_): this;
        norm2(): number;
        nei(arg0: Internal.ComplexFloat_): this;
        subi(arg0: number): this;
        mul(arg0: Internal.ComplexFloatMatrix_): this;
        andi(arg0: number): this;
        addi(arg0: Internal.ComplexFloat_): this;
        put(arg0: number, arg1: number[], arg2: Internal.ComplexFloatMatrix_): this;
        "in"(arg0: Internal.DataInputStream_): void;
        andi(arg0: Internal.ComplexFloatMatrix_): this;
        subi(arg0: Internal.ComplexFloatMatrix_): this;
        eqi(arg0: Internal.ComplexFloatMatrix_, arg1: Internal.ComplexFloatMatrix_): this;
        put(arg0: Internal.ComplexFloatMatrix_, arg1: number, arg2: Internal.ComplexFloat_): this;
        mmuli(arg0: Internal.ComplexFloat_): this;
        andi(arg0: Internal.ComplexFloat_, arg1: Internal.ComplexFloatMatrix_): this;
        put(arg0: number, arg1: number, arg2: number): this;
        mmul(arg0: number): this;
        sub(arg0: Internal.ComplexFloatMatrix_): this;
        muli(arg0: number): this;
        putImag(arg0: number[], arg1: number): this;
        put(arg0: number, arg1: number, arg2: number, arg3: number): this;
        toArray(): Internal.ComplexFloat[];
        hermitian(): this;
        put(arg0: Internal.ComplexFloatMatrix_, arg1: number): this;
        toArray2(): Internal.ComplexFloat[][];
        put(arg0: number[], arg1: number[], arg2: number): this;
        getColumns(): number;
        put(arg0: number, arg1: Internal.ComplexFloat_): this;
        divi(arg0: number): this;
        mean(): Internal.ComplexFloat;
        get vector(): boolean
        get length(): number
        get square(): boolean
        get columnVector(): boolean
        get empty(): boolean
        get rowVector(): boolean
        get rows(): number
        get real(): Internal.FloatMatrix
        get scalar(): boolean
        get columns(): number
        length: number;
        rows: number;
        columns: number;
        data: number[];
    }
    type ComplexFloatMatrix_ = ComplexFloatMatrix;
    class SemaphoreBlockEntity extends Internal.SmartBlockEntity implements Internal.IOverridableSignal {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        wasCachedSearchingUpsideDown(): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        railways$refresh(signalBE: Internal.SignalBlockEntity_, state: Internal.SignalBlockEntity$SignalState_, ticks: number): void;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        railways$refresh(signalBE: Internal.SignalBlockEntity_, state: Internal.SignalBlockEntity$SignalState_, ticks: number, distantSignal: boolean): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        railways$getOverriddenState(): Internal.Optional<Internal.SignalBlockEntity$SignalState>;
        get infiniteBoundingBox(): Internal.AABB
        isDistantSignal: boolean;
        readonly armPosition: Internal.LerpedFloat;
        isValid: boolean;
        signalState: Internal.SignalBlockEntity$SignalState;
    }
    type SemaphoreBlockEntity_ = SemaphoreBlockEntity;
    interface ScreenInputDelegate {
        abstract architectury_delegateInputs(): Internal.Screen;
        (): Internal.Screen_;
    }
    type ScreenInputDelegate_ = ScreenInputDelegate;
    interface BlockEntityGetter {
        abstract getLoadedExistingBlockEntity(arg0: BlockPos_): Internal.BlockEntity;
        (arg0: BlockPos): Internal.BlockEntity_;
    }
    type BlockEntityGetter_ = BlockEntityGetter;
    interface BlockCountingSection {
        abstract mayContainAny(arg0: Internal.TrackedBlockStatePredicate_): boolean;
        (arg0: Internal.TrackedBlockStatePredicate): boolean;
    }
    type BlockCountingSection_ = BlockCountingSection;
    class MushroomCow extends Internal.Cow implements Internal.Shearable, Internal.IShearable, Internal.VariantHolder<Internal.MushroomCow$MushroomType> {
        constructor($$0: Internal.EntityType_<Internal.MushroomCow>, $$1: Internal.Level_)
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        setVariant($$0: Internal.MushroomCow$MushroomType_): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        readyForShearing(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getVariant(): any;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        getVariant(): Internal.MushroomCow$MushroomType;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<any>;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        shear($$0: Internal.SoundSource_): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        static checkMushroomSpawnRules($$0: Internal.EntityType_<Internal.MushroomCow>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.RandomSource_): boolean;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getBreedOffspring($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): this;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        setVariant(arg0: any): void;
        runCommand(command: string): number;
        set variant($$0: Internal.MushroomCow$MushroomType_)
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get variant(): any
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        get variant(): Internal.MushroomCow$MushroomType
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        set variant(arg0: any)
    }
    type MushroomCow_ = MushroomCow;
    class ClientboundBlockDestructionPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: number, $$1: BlockPos_, $$2: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        getProgress(): number;
        handle(arg0: Internal.PacketListener_): void;
        getPos(): BlockPos;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        getId(): number;
        get progress(): number
        get pos(): BlockPos
        get skippable(): boolean
        get id(): number
    }
    type ClientboundBlockDestructionPacket_ = ClientboundBlockDestructionPacket;
    class StairBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock, Internal.IMixinStairsBlock {
        constructor($$0: Internal.BlockState_, $$1: Internal.BlockBehaviour$Properties_)
        static isStairs($$0: Internal.BlockState_): boolean;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        static invokeGetStairShape(state: Internal.BlockState_, worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.StairsShape;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static invokeGetStairShape$litematica_$md$fca01f$0(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.StairsShape;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly SHAPE: Internal.EnumProperty<Internal.StairsShape>;
        static readonly HALF: Internal.EnumProperty<Internal.Half>;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type StairBlock_ = StairBlock;
    class VersionIntervalImpl implements Internal.VersionInterval {
        constructor(arg0: Internal.Version_, arg1: boolean, arg2: Internal.Version_, arg3: boolean)
        static and(arg0: Internal.Collection_<Internal.VersionInterval>, arg1: Internal.Collection_<Internal.VersionInterval>): Internal.List<Internal.VersionInterval>;
        getMin(): Internal.Version;
        isMaxInclusive(): boolean;
        getMax(): Internal.Version;
        static not(arg0: Internal.VersionInterval_): Internal.List<Internal.VersionInterval>;
        not(): Internal.List<Internal.VersionInterval>;
        static and(arg0: Internal.VersionInterval_, arg1: Internal.VersionInterval_): Internal.VersionInterval;
        and(arg0: Internal.VersionInterval_): Internal.VersionInterval;
        isMinInclusive(): boolean;
        static not(arg0: Internal.Collection_<Internal.VersionInterval>): Internal.List<Internal.VersionInterval>;
        or(arg0: Internal.Collection_<Internal.VersionInterval>): Internal.List<Internal.VersionInterval>;
        isSemantic(): boolean;
        static or(arg0: Internal.Collection_<Internal.VersionInterval>, arg1: Internal.VersionInterval_): Internal.List<Internal.VersionInterval>;
        get min(): Internal.Version
        get maxInclusive(): boolean
        get max(): Internal.Version
        get minInclusive(): boolean
        get semantic(): boolean
    }
    type VersionIntervalImpl_ = VersionIntervalImpl;
    class LightSectionDebugRenderer implements Internal.DebugRenderer$SimpleDebugRenderer {
        constructor($$0: Internal.Minecraft_, $$1: Internal.LightLayer_)
        render($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: number, $$3: number, $$4: number): void;
        clear(): void;
    }
    type LightSectionDebugRenderer_ = LightSectionDebugRenderer;
}
declare namespace it.unimi.dsi.fastutil.longs {
    interface LongConsumer extends Internal.LongConsumer, Internal.Consumer<number> {
        andThen(arg0: Internal.LongConsumer_): Internal.LongConsumer;
        andThen(arg0: it.unimi.dsi.fastutil.longs.LongConsumer_): this;
        /**
         * @deprecated
        */
        accept(arg0: any): void;
        /**
         * @deprecated
        */
        accept(arg0: number): void;
        /**
         * @deprecated
        */
        andThen(arg0: Internal.Consumer_<number>): Internal.Consumer<number>;
        abstract accept(arg0: number): void;
        (arg0: number): void;
    }
    type LongConsumer_ = LongConsumer;
}
declare namespace io.github.fabricators_of_create.porting_lib.mixin.accessors.client.accessor {
    interface ScreenAccessor {
        abstract port_lib$getMinecraft(): Internal.Minecraft;
        abstract port_lib$getChildren(): Internal.List<Internal.GuiEventListener>;
        abstract port_lib$getRenderables(): Internal.List<Internal.Renderable>;
    }
    type ScreenAccessor_ = ScreenAccessor;
}
